/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.OcciConnector;
import org.gcube.vomanagement.occi.exceptions.UnsupportedCredentialsTypeException;
import org.gcube.vomanagement.occi.utils.ScriptUtil;

public class ConnectorFactory {
    private Map<String, FHNConnector> connectors = new HashMap();

    public FHNConnector getConnector(VMProvider vmp) {
        String vmpId = vmp.getId();
        if (!this.connectors.containsKey(vmpId)) {
            this.connectors.put(vmpId, this.createConnector(vmp));
        }
        return (FHNConnector)this.connectors.get(vmpId);
    }

    public FHNConnector createConnector(VMProvider vmp) {
        try {
            vmp.getCredentials().setEncodedCredentails(ScriptUtil.getScriptFromFile((File)new File(vmp.getCredentials().getEncodedCredentails())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OcciConnector connector = null;
        try {
            connector = new OcciConnector(vmp);
            connector.setTrustStore("/etc/grid-security/certificates");
        }
        catch (UnsupportedCredentialsTypeException e) {
            e.printStackTrace();
        }
        return connector;
    }
}

