/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RuntimeResource;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;

public class RuntimeResourceHandler
implements ResourceHandler<RuntimeResource> {
    private static GCUBELog logger = new GCUBELog(RuntimeResourceHandler.class);

    @Override
    public List<RuntimeResource> initialize() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERuntimeResourceQuery query = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
        List gcubeRuntimeResourceList = client.execute((ISQuery)query, GCUBEScope.getScope((String)ScopeProvider.instance.get()));
        ArrayList<RuntimeResource> runtimeResources = new ArrayList<RuntimeResource>();
        for (GCUBERuntimeResource gcubeRuntimeResource : gcubeRuntimeResourceList) {
            try {
                RuntimeResource runtimeResource = new RuntimeResource(gcubeRuntimeResource.getID(), gcubeRuntimeResource.getName(), gcubeRuntimeResource.getCategory(), gcubeRuntimeResource.getDescription());
                this.insert(runtimeResource);
                runtimeResources.add(runtimeResource);
            }
            catch (Exception e) {
                logger.error((Object)"error inserting runtimeResource", (Throwable)e);
            }
        }
        return runtimeResources;
    }

    @Override
    public void add(RuntimeResource resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String resourceId) throws Exception {
        Dao runtimeResourceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RuntimeResource.class);
        runtimeResourceDao.deleteById((Object)resourceId);
    }

    private void insert(RuntimeResource resource) throws Exception {
        Dao runtimeResourceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RuntimeResource.class);
        runtimeResourceDao.createOrUpdate((Object)resource);
        logger.trace((Object)("inserting runtimeResource with id " + resource.getId()));
    }
}

