/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.db;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.sql.SQLException;
import java.util.Hashtable;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;

public class DBInterface {
    private static Hashtable<String, ConnectionSource> connectionMapping = new Hashtable();
    private static String dbFileRoot = ServiceContext.getContext().getPersistenceRoot() + File.separator + "vreModelerDB";
    private static GCUBELog logger = new GCUBELog(DBInterface.class);

    public static synchronized boolean dbAlreadyCreated(String scope) {
        try {
            String dbFile = dbFileRoot + scope.toString().replace("/", "-");
            logger.debug((Object)("dbfile to connect is " + dbFile));
            new JdbcConnectionSource("jdbc:hsqldb:file:" + dbFile + ";ifexists=true", "sa", "");
        }
        catch (Exception e) {
            logger.trace((Object)"the database does't exists");
            return false;
        }
        return true;
    }

    public static synchronized ConnectionSource connect(String scope) throws SQLException {
        if (connectionMapping.get(scope) == null) {
            try {
                Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage());
            }
            String dbFile = dbFileRoot + scope.toString().replace("/", "-");
            JdbcConnectionSource connectionSource = new JdbcConnectionSource("jdbc:hsqldb:file:" + dbFile, "sa", "");
            connectionMapping.put(scope, (ConnectionSource)connectionSource);
        }
        return connectionMapping.get(scope);
    }

    public static ConnectionSource connect() throws SQLException {
        return DBInterface.connect(ScopeProvider.instance.get());
    }
}

