/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.consumers;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.consumers.GHNConsumer;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Collection;
import org.gcube.vremanagement.vremodeler.resources.handlers.CollectionHandler;

public class CollectionConsumer
extends ISNotifier.BaseNotificationConsumer {
    private GCUBELog logger = new GCUBELog(GHNConsumer.class);
    public static final ISNotifier.GCUBENotificationTopic collectionTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource"));
    private GCUBEScope scope;

    public CollectionConsumer(GCUBEScope scope) {
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotificationReceived(ISNotifier.NotificationEvent event) {
        try {
            ScopeProvider.instance.set(this.scope.toString());
            ServiceContext.getContext().setScope(this.scope);
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            if (operation.compareTo("create") == 0) {
                this.logger.trace((Object)"adding a new Collection in DB");
                GCUBEGenericResource collection = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                collection.load((Reader)new StringReader(profile));
                Collection coll = new Collection(collection.getID(), collection.getName(), collection.getDescription());
                new CollectionHandler().add(coll);
            } else if (operation.compareTo("destroy") == 0) {
                this.logger.trace((Object)"removing a collection from DB");
                new CollectionHandler().drop(id);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error in notification received", (Throwable)e);
        }
        finally {
            ScopeProvider.instance.reset();
        }
    }

    static {
        collectionTopic.setUseRenotifier(false);
        collectionTopic.setPrecondition("//profile[contains(.,'<SecondaryType>GCUBECollection</SecondaryType>') and contains(.,'<user>true</user>')]");
    }
}

