/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;
import org.gcube.vremanagement.vremodeler.resources.handlers.RunningInstancesHandler;

public class GHNHandler
implements ResourceHandler<Ghn> {
    private static GCUBELog logger = new GCUBELog(GHNHandler.class);
    public static final String tableName = "GHN";

    @Override
    public List<Ghn> initialize() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGHNQuery query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHNDescription/Type", "Dynamic")});
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/GHNDescription/Status", "certified")});
        List gcubeHostingNodeList = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
        ArrayList<Ghn> ghns = new ArrayList<Ghn>();
        for (GCUBEHostingNode gcubeHostingNode : gcubeHostingNodeList) {
            try {
                Ghn ghn = new Ghn(gcubeHostingNode.getID(), gcubeHostingNode.getNodeDescription().getName(), gcubeHostingNode.getSite().getLocation(), gcubeHostingNode.getSite().getCountry(), gcubeHostingNode.getSite().getDomain(), gcubeHostingNode.getNodeDescription().getMemory().getAvailable(), gcubeHostingNode.getNodeDescription().getLocalAvailableSpace(), false);
                ghn.setSecurityEnabled(gcubeHostingNode.getNodeDescription().isSecurityEnabled());
                this.insert(ghn);
                ghns.add(ghn);
            }
            catch (Exception e) {
                logger.error((Object)"error inserting values in GHN", (Throwable)e);
            }
        }
        return ghns;
    }

    private void insert(Ghn ghn) throws Exception {
        logger.trace((Object)("adding a GHN with id " + ghn.getId()));
        RunningInstancesHandler riHandler = new RunningInstancesHandler(ghn);
        riHandler.initialize();
        Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
        if (ghnDao.idExists((Object)ghn.getId())) {
            ghnDao.update((Object)ghn);
        } else {
            ghnDao.create((Object)ghn);
        }
    }

    @Override
    public void add(Ghn resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String ghnId) throws Exception {
        Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
        ghnDao.deleteById((Object)ghnId);
    }
}

