/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ModelerContext;
import org.gcube.vremanagement.vremodeler.impl.ModelerResource;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.deploy.DeployVRE;
import org.gcube.vremanagement.vremodeler.impl.deploy.UndeployVRE;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.FunctionalityPersisted;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.ResourceInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RunningInstance;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreFunctionalityRelation;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreGhnRelation;
import org.gcube.vremanagement.vremodeler.impl.util.Pair;
import org.gcube.vremanagement.vremodeler.impl.util.ServicePair;
import org.gcube.vremanagement.vremodeler.impl.util.Triple;
import org.gcube.vremanagement.vremodeler.impl.util.Util;
import org.gcube.vremanagement.vremodeler.resources.ResourceDefinition;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityItem;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityList;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityNodes;
import org.gcube.vremanagement.vremodeler.stubs.GHNArray;
import org.gcube.vremanagement.vremodeler.stubs.GHNList;
import org.gcube.vremanagement.vremodeler.stubs.GHNType;
import org.gcube.vremanagement.vremodeler.stubs.GHNTypeMemory;
import org.gcube.vremanagement.vremodeler.stubs.GHNTypeSite;
import org.gcube.vremanagement.vremodeler.stubs.GHNsPerFunctionality;
import org.gcube.vremanagement.vremodeler.stubs.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodeler.stubs.ResourceItem;
import org.gcube.vremanagement.vremodeler.stubs.RunningInstanceMessage;
import org.gcube.vremanagement.vremodeler.stubs.SelectedResourceDescriptionType;
import org.gcube.vremanagement.vremodeler.stubs.SetFunctionality;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;
import org.gcube.vremanagement.vremodeler.utils.Utils;
import org.gcube.vremanagement.vremodeler.utils.reports.DeployReport;
import org.gcube.vremanagement.vremodeler.utils.reports.Status;
import org.globus.wsrf.ResourceException;

public class ModelerService {
    private static final GCUBELog logger = new GCUBELog(ModelerService.class);

    protected ModelerResource getResource() throws ResourceException {
        return (ModelerResource)ModelerContext.getPortTypeContext().getWSHome().find();
    }

    public void setDescription(VREDescription request) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            String vreId = this.getResource().getId();
            if (!request.getEndTime().after(request.getStartTime())) {
                throw new Exception("the end date is before or the same of the start date");
            }
            if (vreDao.idExists((Object)vreId)) {
                VRE vre = (VRE)vreDao.queryForId((Object)vreId);
                vre.setName(request.getName());
                vre.setIntervalFrom(request.getStartTime());
                vre.setIntervalTo(request.getEndTime());
                vre.setDescription(request.getDescription());
                vre.setVreDesigner(request.getDesigner());
                vre.setVreManager(request.getManager());
                vreDao.update((Object)vre);
            } else {
                VRE vre = new VRE(vreId, request.getName(), request.getDescription(), request.getDesigner(), request.getManager(), request.getStartTime(), request.getEndTime(), Status.Incomplete.name());
                vreDao.create((Object)vre);
            }
        }
        catch (Exception e) {
            logger.error((Object)"an error occurs setting the VRE Description", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public VREDescription getDescription(VOID var) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            String vreId = this.getResource().getId();
            VRE vre = (VRE)vreDao.queryForId((Object)vreId);
            if (vre == null) {
                throw new Exception("the vre is not stored in the DB");
            }
            return new VREDescription(vre.getDescription(), vre.getVreDesigner(), vre.getIntervalTo(), vre.getVreManager(), vre.getName(), vre.getIntervalFrom());
        }
        catch (Exception e) {
            logger.error((Object)"error getting VRE informations", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public FunctionalityNodes getFunctionalityNodes(VOID var) throws GCUBEFault {
        logger.trace((Object)"getFunctionalityNodes method");
        FunctionalityNodes functionalityNodes = new FunctionalityNodes();
        try {
            long start = System.currentTimeMillis();
            Dao vreGhnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreGhnRelation.class);
            Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
            Dao vreFunctionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreFunctionalityRelation.class);
            Dao functionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            VRE vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
            List allGhn = ghnDao.queryForAll();
            HashSet recomendedGhn = new HashSet();
            ArrayList<GHNsPerFunctionality> ghnsPerFunctionalityList = new ArrayList<GHNsPerFunctionality>();
            for (FunctionalityPersisted selectedFunctionality : Util.getSelectedFunctionality((Dao<VreFunctionalityRelation, String>)vreFunctionalityDao, (Dao<FunctionalityPersisted, Integer>)functionalityDao, vre.getId())) {
                logger.trace((Object)("found a selected functionality " + selectedFunctionality.getId()));
                if (selectedFunctionality.getParent() == null) continue;
                Triple<Set<Ghn>, Set<RunningInstanceMessage>, Set<RunningInstanceMessage>> functionalityTriple = this.getRecomendedGhn(selectedFunctionality);
                ArrayList<GHNType> ghnsType = new ArrayList<GHNType>();
                for (Ghn ghn : (Set)functionalityTriple.getFirst()) {
                    Pair<RunningInstanceMessage[], Boolean> risPerGhn = this.retrieveRIsPerGhn(ghn);
                    ghnsType.add(new GHNType(ghn.getHost(), ghn.getId(), new GHNTypeMemory(ghn.getDiskSpace(), ghn.getMemoryAvailable()), risPerGhn.getFirst(), ghn.isSecurityEnabled(), false, new GHNTypeSite(ghn.getCountry(), ghn.getDomain(), ghn.getLocation())));
                }
                ghnsPerFunctionalityList.add(new GHNsPerFunctionality(selectedFunctionality.getDescription(), ((Set)functionalityTriple.getSecond()).toArray(new RunningInstanceMessage[0]), new GHNList(ghnsType.toArray(new GHNType[ghnsType.size()])), selectedFunctionality.getId(), functionalityTriple.getThird().toArray(new RunningInstanceMessage[0])));
                recomendedGhn.addAll((Collection)functionalityTriple.getFirst());
            }
            functionalityNodes.setFunctionalities(ghnsPerFunctionalityList.toArray(new GHNsPerFunctionality[ghnsPerFunctionalityList.size()]));
            logger.trace((Object)("fucntionality node has " + functionalityNodes.getFunctionalities().length + " elements"));
            List<Ghn> selectedGhn = this.retrieveSelectedGhns((Dao<VreGhnRelation, String>)vreGhnDao, (Dao<Ghn, String>)ghnDao);
            ArrayList<GHNType> selectableGhnTypes = new ArrayList<GHNType>();
            for (Ghn ghn : allGhn) {
                Pair<RunningInstanceMessage[], Boolean> risPerGhn = this.retrieveRIsPerGhn(ghn);
                logger.trace((Object)(ghn.getHost() + " has " + risPerGhn.getFirst().length + " runningInstances "));
                if (recomendedGhn.contains(ghn)) continue;
                if (risPerGhn.getSecond().booleanValue()) {
                    selectableGhnTypes.add(new GHNType(ghn.getHost(), ghn.getId(), new GHNTypeMemory(ghn.getDiskSpace(), ghn.getMemoryAvailable()), risPerGhn.getFirst(), ghn.isSecurityEnabled(), selectedGhn.contains(ghn), new GHNTypeSite(ghn.getCountry(), ghn.getDomain(), ghn.getLocation())));
                    continue;
                }
                if (!selectedGhn.contains(ghn)) continue;
                DeleteBuilder deleteBuilder = vreGhnDao.deleteBuilder();
                deleteBuilder.setWhere(deleteBuilder.where().eq("ghn_id", (Object)ghn).and().eq("vre_id", (Object)vre));
                vreGhnDao.delete(deleteBuilder.prepare());
            }
            logger.trace((Object)("selectable ghnType are " + selectableGhnTypes.size()));
            functionalityNodes.setSelectableGHNs(new GHNList(selectableGhnTypes.toArray(new GHNType[selectableGhnTypes.size()])));
            logger.trace((Object)("method took " + (System.currentTimeMillis() - start)));
        }
        catch (Exception e) {
            logger.error((Object)"error retreiving GHNs", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return functionalityNodes;
    }

    private List<Ghn> retrieveSelectedGhns(Dao<VreGhnRelation, String> vreGhnDao, Dao<Ghn, String> ghnDao) throws Exception {
        QueryBuilder vreGhnQb = vreGhnDao.queryBuilder();
        vreGhnQb.selectColumns(new String[]{"ghn_id"});
        SelectArg userSelectArg = new SelectArg();
        vreGhnQb.where().eq("vre_id", (Object)userSelectArg);
        QueryBuilder ghnQb = ghnDao.queryBuilder();
        ghnQb.where().in("id", vreGhnQb);
        ghnQb.prepare().setArgumentHolderValue(0, (Object)this.getResource().getId());
        return ghnQb.query();
    }

    private Pair<RunningInstanceMessage[], Boolean> retrieveRIsPerGhn(Ghn ghn) {
        boolean selectable = true;
        Collection<RunningInstance> runningInstances = ghn.getRunningInstances();
        int runningInstancesSize = runningInstances.size();
        RunningInstanceMessage[] relatedRis = new RunningInstanceMessage[runningInstancesSize];
        int i = 0;
        for (RunningInstance ri : runningInstances) {
            ServicePair sp = new ServicePair(ri.getServiceName(), ri.getServiceClass());
            if (!ServiceContext.getContext().getBaseServiceForGhn().contains(sp)) {
                selectable = false;
            }
            relatedRis[i++] = new RunningInstanceMessage(ri.getServiceClass(), ri.getServiceName());
        }
        return new Pair<RunningInstanceMessage[], Boolean>(relatedRis, selectable);
    }

    private Triple<Set<Ghn>, Set<RunningInstanceMessage>, Set<RunningInstanceMessage>> getRecomendedGhn(FunctionalityPersisted ... functionalities) throws Exception {
        Dao runningInstanceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RunningInstance.class);
        HashSet<ServicePair> servicePairSet = new HashSet<ServicePair>();
        for (FunctionalityPersisted functionality : functionalities) {
            if (functionality.getParent() == null) continue;
            servicePairSet.addAll(functionality.getServices());
        }
        SelectArg serviceClassArg = new SelectArg();
        SelectArg serviceNameArg = new SelectArg();
        PreparedQuery preparedQuery = runningInstanceDao.queryBuilder().where().eq("serviceClass", (Object)serviceClassArg).and().eq("serviceName", (Object)serviceNameArg).prepare();
        HashSet<Ghn> recomendedGhnSet = new HashSet<Ghn>();
        HashSet<RunningInstanceMessage> missingServices = new HashSet<RunningInstanceMessage>();
        HashSet<RunningInstanceMessage> foundServices = new HashSet<RunningInstanceMessage>();
        for (ServicePair servicePair : servicePairSet) {
            preparedQuery.setArgumentHolderValue(0, (Object)servicePair.getServiceClass());
            preparedQuery.setArgumentHolderValue(1, (Object)servicePair.getServiceName());
            logger.trace((Object)("prepared query is " + preparedQuery.getStatement()));
            logger.trace((Object)("checking for service " + servicePair.getServiceName() + " " + servicePair.getServiceClass()));
            RunningInstanceMessage runningInstanceStub = new RunningInstanceMessage(servicePair.getServiceClass(), servicePair.getServiceName());
            List runningInstances = runningInstanceDao.query(preparedQuery);
            if (runningInstances.size() > 0) {
                foundServices.add(runningInstanceStub);
                for (RunningInstance ri : runningInstances) {
                    logger.trace((Object)"adding recomendedGhn");
                    recomendedGhnSet.add(ri.getGhn());
                }
                continue;
            }
            missingServices.add(runningInstanceStub);
        }
        return new Triple<Set<Ghn>, Set<RunningInstanceMessage>, Set<RunningInstanceMessage>>(recomendedGhnSet, foundServices, missingServices);
    }

    public void setGHNs(GHNArray request) throws GCUBEFault {
        try {
            if (this.getResource().isUseCloud()) {
                throw new GCUBEFault(new String[]{"deploy on cloud is selected, the ghns cannot be set"});
            }
        }
        catch (ResourceException e1) {
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        try {
            String instanceID = this.getResource().getId();
            Dao vreGhnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreGhnRelation.class);
            Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            DeleteBuilder deleteBuilder = vreGhnDao.deleteBuilder();
            deleteBuilder.setWhere(deleteBuilder.where().eq("vre_id", (Object)instanceID));
            vreGhnDao.delete(deleteBuilder.prepare());
            VRE vre = (VRE)vreDao.queryForId((Object)instanceID);
            for (String ghnId : request.getGHNElement()) {
                vreGhnDao.create((Object)new VreGhnRelation(vre, (Ghn)ghnDao.queryForId((Object)ghnId)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error setting GHNs ", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public FunctionalityList getFunctionality(VOID var) throws GCUBEFault {
        ArrayList<FunctionalityItem> functionalityItemList = new ArrayList<FunctionalityItem>();
        try {
            Dao vreFunctionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreFunctionalityRelation.class);
            Dao functionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            VRE vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
            List rootFunctionalities = functionalityDao.query(functionalityDao.queryBuilder().where().isNull("parent_id").prepare());
            List<FunctionalityPersisted> selectedFunctionalities = Util.getSelectedFunctionality((Dao<VreFunctionalityRelation, String>)vreFunctionalityDao, (Dao<FunctionalityPersisted, Integer>)functionalityDao, this.getResource().getId());
            for (FunctionalityPersisted rootFuncionality : rootFunctionalities) {
                functionalityItemList.add(this.retrieveFunctionalityItems(rootFuncionality, selectedFunctionalities, (Dao<FunctionalityPersisted, Integer>)functionalityDao, vre));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error retrieving functionality", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new FunctionalityList(functionalityItemList.toArray(new FunctionalityItem[functionalityItemList.size()]));
    }

    private FunctionalityItem retrieveFunctionalityItems(FunctionalityPersisted mainFunctionality, List<FunctionalityPersisted> selectedFunctionality, Dao<FunctionalityPersisted, Integer> functionalityDao, VRE vre) throws Exception {
        FunctionalityItem functionalityItem = new FunctionalityItem();
        functionalityItem.setId(mainFunctionality.getId());
        functionalityItem.setName(mainFunctionality.getName());
        functionalityItem.setMandatory(mainFunctionality.isMandatory());
        if (mainFunctionality.isMandatory()) {
            functionalityItem.setSelected(true);
        } else {
            functionalityItem.setSelected(selectedFunctionality.contains(mainFunctionality));
        }
        functionalityItem.setDescription(mainFunctionality.getDescription());
        ArrayList<FunctionalityItem> subFunctionalitiesItems = new ArrayList<FunctionalityItem>();
        for (FunctionalityPersisted subfunctionality : functionalityDao.query(functionalityDao.queryBuilder().where().eq("parent_id", (Object)mainFunctionality).prepare())) {
            FunctionalityItem subFunctionalityItem = new FunctionalityItem();
            subFunctionalityItem.setId(subfunctionality.getId());
            subFunctionalityItem.setName(subfunctionality.getName());
            subFunctionalityItem.setDescription(subfunctionality.getDescription());
            subFunctionalityItem.setMandatory(subfunctionality.isMandatory());
            if (subfunctionality.isMandatory()) {
                subFunctionalityItem.setSelected(true);
            } else {
                subFunctionalityItem.setSelected(selectedFunctionality.contains(subfunctionality));
            }
            ArrayList<ResourceDescriptionItem> resourcesItemsList = new ArrayList<ResourceDescriptionItem>();
            for (ResourceDefinition<?> resourceEntry : subfunctionality.getSelectableResources()) {
                ResourceDescriptionItem resourcesItem = new ResourceDescriptionItem();
                resourcesItem.setId(resourceEntry.getId());
                resourcesItem.setDescription(resourceEntry.getDescription());
                resourcesItem.setMaxSelectable(resourceEntry.getMaxSelectable());
                resourcesItem.setMinSelectable(resourceEntry.getMinSelectable());
                ArrayList<ResourceItem> resourceItemList = new ArrayList<ResourceItem>();
                for (ResourceInterface resource : resourceEntry.getResources()) {
                    boolean selected = false;
                    if (vre != null && vre.getSelectableResourcesMap().containsKey(resourceEntry.getId())) {
                        selected = vre.getSelectableResourcesMap().get(resourceEntry.getId()).contains(resource.getId());
                    }
                    resourceItemList.add(new ResourceItem(resource.getDescription(), resource.getId(), resource.getName(), selected));
                }
                resourcesItem.setResource(resourceItemList.toArray(new ResourceItem[resourceItemList.size()]));
                resourcesItemsList.add(resourcesItem);
            }
            subFunctionalityItem.setSelectableResourcesDescription(resourcesItemsList.toArray(new ResourceDescriptionItem[resourcesItemsList.size()]));
            subFunctionalitiesItems.add(subFunctionalityItem);
        }
        functionalityItem.setChilds(subFunctionalitiesItems.toArray(new FunctionalityItem[subFunctionalitiesItems.size()]));
        return functionalityItem;
    }

    public void setFunctionality(SetFunctionality request) throws GCUBEFault {
        logger.trace((Object)"Set Functionality called");
        try {
            String instanceID = this.getResource().getId();
            Dao vreFunctionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreFunctionalityRelation.class);
            Dao functionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            DeleteBuilder deleteBuilder = vreFunctionalityDao.deleteBuilder();
            deleteBuilder.setWhere(deleteBuilder.where().eq("vre_id", (Object)instanceID));
            vreFunctionalityDao.delete(deleteBuilder.prepare());
            VRE vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
            HashMap<String, ArrayList<String>> selectedMap = new HashMap<String, ArrayList<String>>();
            if (request.getResourcesDescription() != null) {
                for (SelectedResourceDescriptionType resourceDescriptionItem : request.getResourcesDescription()) {
                    ArrayList<String> resourcesId = new ArrayList<String>();
                    if (resourceDescriptionItem.getResourceId() != null) {
                        for (String id : resourceDescriptionItem.getResourceId()) {
                            resourcesId.add(id);
                        }
                    }
                    selectedMap.put(resourceDescriptionItem.getDescriptionId(), resourcesId);
                }
            }
            vre.setSelectableResourcesMap(selectedMap);
            vreDao.update((Object)vre);
            for (int functionalityId : request.getFunctionalityIds()) {
                vreFunctionalityDao.create((Object)new VreFunctionalityRelation(vre, (FunctionalityPersisted)functionalityDao.queryForId((Object)functionalityId)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error setting functionalities", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public String getQuality(VOID var) throws GCUBEFault {
        return Util.prepareQualityXML();
    }

    public void setQuality(String request) throws GCUBEFault {
    }

    public void setVREtoPendingState(VOID var) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            VRE vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
            vre.setStatus(Status.Pending.name());
            vreDao.update((Object)vre);
        }
        catch (Exception e) {
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public void deployVRE(VOID var) throws GCUBEFault {
        VRE vre;
        String resourceID;
        try {
            ModelerResource resource = this.getResource();
            resourceID = resource.getId();
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving the Resource Requested", (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[0]);
        }
        if (Status.valueOf((String)vre.getStatus()) != Status.Pending) {
            throw new GCUBEFault(new String[]{"cannot deploy this vre, the status of " + vre.getName() + " is " + vre.getStatus()});
        }
        try {
            DeployVRE deployVREThread = new DeployVRE(resourceID, ServiceContext.getContext().getScope());
            ServiceContext.getContext().setScope(deployVREThread, ServiceContext.getContext().getScope());
            logger.trace((Object)"Deploy VRE thread started");
            deployVREThread.start();
        }
        catch (Exception e) {
            logger.error((Object)"error trying to deploy ", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public String checkStatus(VOID var) throws Exception {
        logger.trace((Object)("is deploy Report null?" + (this.getResource().getDeployReport() == null)));
        return Utils.toXML((DeployReport)this.getResource().getDeployReport());
    }

    public void undeployVRE(VOID var) throws GCUBEFault {
        try {
            UndeployVRE undeploy = new UndeployVRE(this.getResource().getId());
            ServiceContext.getContext().setScope(undeploy, ServiceContext.getContext().getScope());
            undeploy.start();
        }
        catch (Exception e) {
            logger.error((Object)"error undeploying vre", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public void setUseCloud(boolean val) throws Exception {
        this.getResource().setUseCloud(val);
        this.getResource().store();
    }

    public boolean isUseCloud(VOID r) throws Exception {
        return this.getResource().isUseCloud();
    }

    public void setCloudVMs(int numberOfVMs) throws Exception {
        ModelerResource resource = this.getResource();
        if (!resource.isUseCloud()) {
            throw new Exception("the number of VMs cannot be set, you are not using cloud deployement");
        }
        resource.setNumberOfVMsForCloud(numberOfVMs);
        resource.store();
    }

    public int getCloudVMs(VOID r) throws Exception {
        ModelerResource resource = this.getResource();
        if (!resource.isUseCloud()) {
            throw new Exception("the number of VMs cannot be returned, you are not using cloud deployement");
        }
        return resource.getNumberOfVMsForCloud();
    }

    public void renewVRE(Calendar request) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            VRE vre = this.getCurrentVRE((Dao<VRE, String>)vreDao);
            if (!request.after(vre.getIntervalTo())) {
                throw new Exception("the new date is before the exising expiring date");
            }
            vre.setIntervalTo(request);
            vreDao.update((Object)vre);
        }
        catch (Exception e) {
            logger.error((Object)"error renewing the VRE expire time", (Throwable)e);
            throw new GCUBEFault(new String[]{"error renewing the VRE expire time"});
        }
    }

    private VRE getCurrentVRE(Dao<VRE, String> vreDao) throws Exception {
        String vreId = this.getResource().getId();
        VRE vre = (VRE)vreDao.queryForId((Object)vreId);
        if (vre == null) {
            logger.warn((Object)("vre with id " + vreId + " has not been created"));
            throw new GCUBEFault(new String[]{"vre with id " + vreId + " has not been created"});
        }
        return vre;
    }
}

