/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.db;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.sql.SQLException;
import java.util.Hashtable;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;

public class DBInterface {
    private static Hashtable<String, ConnectionSource> connectionMapping = new Hashtable();
    private static String dbFile = ServiceContext.getContext().getPersistenceRoot() + File.separator + "vreModelerDB";
    private static GCUBELog logger = new GCUBELog(DBInterface.class);

    public static synchronized boolean dbAlreadyCreated(GCUBEScope scope) {
        try {
            new JdbcConnectionSource("jdbc:hsqldb:file:" + dbFile + scope.toString().replace("/", "-") + ";ifexists=true", "sa", "");
        }
        catch (Exception e) {
            logger.trace((Object)"the database does't exists");
            return false;
        }
        return true;
    }

    public static synchronized ConnectionSource connect(GCUBEScope scope) throws SQLException {
        if (connectionMapping.get(scope.toString()) == null) {
            logger.info((Object)dbFile);
            try {
                Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage());
            }
            JdbcConnectionSource connectionSource = new JdbcConnectionSource("jdbc:hsqldb:file:" + dbFile + scope.toString().replace("/", "-"), "sa", "");
            connectionMapping.put(scope.toString(), (ConnectionSource)connectionSource);
        }
        return connectionMapping.get(scope.toString());
    }

    public static ConnectionSource connect() throws SQLException {
        return DBInterface.connect(ServiceContext.getContext().getScope());
    }
}

