/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.consumers;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Service;
import org.gcube.vremanagement.vremodeler.resources.handlers.ServiceHandler;

public class ServiceConsumer
extends ISNotifier.BaseNotificationConsumer {
    private GCUBELog logger = new GCUBELog(ServiceConsumer.class);
    public static final ISNotifier.GCUBENotificationTopic serviceTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "Service"));
    private GCUBEScope scope;

    public ServiceConsumer(GCUBEScope scope) {
        this.scope = scope;
    }

    public void onNotificationReceived(ISNotifier.NotificationEvent event) {
        try {
            ServiceContext.getContext().setScope(this.scope);
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            this.logger.info((Object)("notification received for service " + id + " and operation " + operation));
            if (operation.equals("update") || operation.equals("create")) {
                this.logger.trace((Object)("notification received for service with id " + id + " in scope " + this.scope.toString()));
                GCUBEService gcubeService = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
                String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                gcubeService.load((Reader)new StringReader(profile));
                String packageName = null;
                String packageVersion = null;
                for (Package packageSW : gcubeService.getPackages()) {
                    if (packageSW instanceof MainPackage) {
                        packageName = packageSW.getName();
                        packageVersion = packageSW.getVersion();
                        break;
                    }
                    if (packageName != null && packageVersion != null) continue;
                    packageName = packageSW.getName();
                    packageVersion = packageSW.getVersion();
                }
                Service service = new Service(gcubeService.getID(), gcubeService.getServiceClass(), gcubeService.getServiceName(), gcubeService.getVersion(), packageName, packageVersion);
                new ServiceHandler().add(service);
            } else if (operation.compareTo("destroy") == 0) {
                this.logger.trace((Object)"notification received for service with operation destroy");
                new ServiceHandler().drop(id);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error in service notification", (Throwable)e);
        }
    }

    static {
        serviceTopic.setUseRenotifier(false);
    }
}

