/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.deploy;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.vremanagement.resourcemanager.stubs.binder.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.PackageItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.binder.SoftwareList;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.CreateScopeParameters;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.OptionsParameters;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.ScopeControllerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.ScopeOption;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ModelerContext;
import org.gcube.vremanagement.vremodeler.impl.ModelerResource;
import org.gcube.vremanagement.vremodeler.impl.ModelerService;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.deploy.DeployGHNsOnCloud;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.FunctionalityPersisted;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.GenericResource;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.ResourceInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RunningInstance;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Service;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreFunctionalityRelation;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreGhnRelation;
import org.gcube.vremanagement.vremodeler.impl.util.ReportFiller;
import org.gcube.vremanagement.vremodeler.impl.util.ResourceManagerPorts;
import org.gcube.vremanagement.vremodeler.impl.util.ServicePair;
import org.gcube.vremanagement.vremodeler.impl.util.Util;
import org.gcube.vremanagement.vremodeler.resources.ResourceDefinition;
import org.gcube.vremanagement.vremodeler.stubs.deployreport.DeployReport;
import org.gcube.vremanagement.vremodeler.stubs.deployreport.Status;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class DeployVRE
extends Thread {
    private static GCUBELog logger = new GCUBELog(ModelerService.class);
    private ModelerResource wsResource = null;
    private String resourceId;
    private GCUBEScope startingScope;
    private VRE vre = null;
    private Dao<VRE, String> vreDao;
    private String targetScope;
    private ResourceManagerPorts ports;

    public DeployVRE(String resourceId, GCUBEScope scope) throws GCUBEFault, Exception {
        this.resourceId = resourceId;
        this.startingScope = scope;
        try {
            this.vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            this.vre = (VRE)this.vreDao.queryForId((Object)resourceId);
            this.targetScope = this.startingScope + "/" + this.vre.getName();
            logger.trace((Object)("target scope is " + this.targetScope));
        }
        catch (Exception e) {
            logger.error((Object)("error retrieving the VRE with id " + resourceId), (Throwable)e);
            throw e;
        }
    }

    private ModelerResource getResource() throws ResourceException {
        if (this.wsResource == null) {
            this.wsResource = (ModelerResource)ModelerContext.getPortTypeContext().getWSHome().find((ResourceKey)ModelerContext.getPortTypeContext().makeKey(this.resourceId));
        }
        return this.wsResource;
    }

    @Override
    public void run() {
        block13: {
            try {
                this.getResource().setDeployReport(new DeployReport());
                this.getResource().getDeployReport().setStatus(Status.Running);
                this.getResource().store();
                this.vre.setStatus(Status.Running.toString());
                this.vreDao.update((Object)this.vre);
                this.ports = ResourceManagerPorts.get(this.startingScope);
                String[] ghnsToUse = null;
                if (this.getResource().isUseCloud()) {
                    DeployGHNsOnCloud ghnOnCloud = new DeployGHNsOnCloud(this.getResource().getNumberOfVMsForCloud(), this.vre.getName());
                    this.getResource().getDeployReport().setCloudDeployingReport(ghnOnCloud.getReport());
                    try {
                        ghnsToUse = ghnOnCloud.run();
                    }
                    catch (Exception e) {
                        logger.error((Object)"error creating VMs on cloud", (Throwable)e);
                        this.getResource().getDeployReport().getCloudDeployingReport().setStatus(Status.Failed);
                        throw new Exception("error creating VMs on cloud", e);
                    }
                } else {
                    this.getResource().getDeployReport().getCloudDeployingReport().setStatus(Status.Skipped);
                    Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
                    Dao vreGhnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreGhnRelation.class);
                    QueryBuilder vreGhnQb = vreGhnDao.queryBuilder();
                    vreGhnQb.selectColumns(new String[]{"ghn_id"});
                    SelectArg userSelectArg = new SelectArg();
                    vreGhnQb.where().eq("vre_id", (Object)userSelectArg);
                    QueryBuilder ghnQb = ghnDao.queryBuilder();
                    ghnQb.where().in("id", vreGhnQb);
                    ghnQb.prepare().setArgumentHolderValue(0, (Object)this.vre.getId());
                    List ghnList = ghnQb.query();
                    ghnsToUse = new String[ghnList.size()];
                    int i = 0;
                    for (Ghn selectedGHN : ghnQb.query()) {
                        ghnsToUse[i++] = selectedGHN.getHost();
                    }
                }
                if (this.createVRE(ghnsToUse)) {
                    this.getResource().getDeployReport().getFunctionalityDeployingReport().setStatus(Status.Finished);
                    this.getResource().getDeployReport().getResourceDeployingReport().setStatus(Status.Finished);
                    this.getResource().getDeployReport().setStatus(Status.Finished);
                    this.getResource().store();
                    this.vre.setStatus(Status.Deployed.toString());
                    this.vreDao.update((Object)this.vre);
                    logger.info((Object)("Deploying of the VRE with id " + this.resourceId + "  FINISHED"));
                    break block13;
                }
                logger.info((Object)("Deploying of the VRE with id " + this.resourceId + " FAILED"));
                throw new Exception("Error Deployng the VRE");
            }
            catch (Exception e) {
                if (e instanceof ConnectException) {
                    ResourceManagerPorts.resetPorts();
                }
                try {
                    this.vre.setStatus(Status.Failed.toString());
                    this.vreDao.update((Object)this.vre);
                    this.getResource().getDeployReport().setStatus(Status.Failed);
                    this.getResource().store();
                }
                catch (Exception e1) {
                    logger.error((Object)"impossible to update the VRE Status", (Throwable)e1);
                }
                try {
                    logger.trace((Object)("trying to dispose the scope " + this.targetScope));
                    this.ports.getScopeController().disposeScope(this.targetScope);
                }
                catch (Exception e2) {
                    logger.error((Object)("error during rollback: cannot dispose the scope created " + this.targetScope), (Throwable)e2);
                }
                logger.error((Object)("Error deploying the VRE with id " + this.resourceId + " "), (Throwable)e);
            }
        }
    }

    private boolean createVRE(String[] ghnsToUse) throws Exception {
        logger.trace((Object)"running the deployVRE");
        Dao vreFunctionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VreFunctionalityRelation.class);
        Dao functionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
        ReportFiller.initializeFunctionalityForReport(this.getResource().getDeployReport().getFunctionalityDeployingReport(), this.resourceId, (Dao<VreFunctionalityRelation, String>)vreFunctionalityDao, (Dao<FunctionalityPersisted, Integer>)functionalityDao);
        ReportFiller.initializeResourcesForReport(this.getResource().getDeployReport().getResourceDeployingReport());
        this.createScope(this.ports.getScopeController());
        logger.trace((Object)"scope created");
        AddResourcesParameters arp = new AddResourcesParameters();
        ResourceList rl = new ResourceList();
        ArrayList<ResourceItem> resItemList = new ArrayList<ResourceItem>();
        Dao runningInstanceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RunningInstance.class);
        HashSet<ServicePair> missingServices = new HashSet<ServicePair>();
        List<FunctionalityPersisted> functs = Util.getSelectedFunctionality((Dao<VreFunctionalityRelation, String>)vreFunctionalityDao, (Dao<FunctionalityPersisted, Integer>)functionalityDao, this.resourceId);
        logger.trace((Object)"adding functionalities");
        for (FunctionalityPersisted functionality : functs) {
            if (functionality.getParent() == null) continue;
            for (ResourceDefinition<?> resourceEntry : functionality.getSelectableResources()) {
                for (ResourceInterface resource : resourceEntry.getResources()) {
                    if (!this.vre.getSelectableResourcesMap().containsKey(resourceEntry.getId()) || !this.vre.getSelectableResourcesMap().get(resourceEntry.getId()).contains(resource.getId())) continue;
                    logger.trace((Object)("adding selectable " + resource.getId() + " " + resource.getResourceType()));
                    resItemList.add(new ResourceItem(resource.getId(), resource.getResourceType()));
                    ReportFiller.addResourceToReport(resource.getId(), resource.getResourceType(), this.getResource().getDeployReport().getResourceDeployingReport());
                }
            }
            for (ResourceDefinition<?> resourceEntry : functionality.getMandatoryResources()) {
                for (ResourceInterface resource : resourceEntry.getResources()) {
                    logger.trace((Object)("adding mandatory " + resource.getId() + " " + resource.getResourceType()));
                    resItemList.add(new ResourceItem(resource.getId(), resource.getResourceType()));
                    ReportFiller.addResourceToReport(resource.getId(), resource.getResourceType(), this.getResource().getDeployReport().getResourceDeployingReport());
                }
            }
            SelectArg serviceClassArg = new SelectArg();
            SelectArg serviceNameArg = new SelectArg();
            PreparedQuery preparedQuery = runningInstanceDao.queryBuilder().where().eq("serviceClass", (Object)serviceClassArg).and().eq("serviceName", (Object)serviceNameArg).prepare();
            for (ServicePair servicePair : functionality.getServices()) {
                preparedQuery.setArgumentHolderValue(0, (Object)servicePair.getServiceClass());
                preparedQuery.setArgumentHolderValue(1, (Object)servicePair.getServiceName());
                logger.trace((Object)("prepared query is " + preparedQuery.getStatement()));
                logger.trace((Object)("checking for service " + servicePair.getServiceName() + " " + servicePair.getServiceClass()));
                List runningInstances = runningInstanceDao.query(preparedQuery);
                if (runningInstances.size() > 0) {
                    for (RunningInstance ri : runningInstances) {
                        resItemList.add(new ResourceItem(ri.getId(), "RunningInstance"));
                        ReportFiller.addResourceToReport(ri.getId(), "RunningInstance", this.getResource().getDeployReport().getResourceDeployingReport());
                        logger.trace((Object)("adding ris  " + ri.getClass() + " " + ri.getServiceName()));
                    }
                    continue;
                }
                missingServices.add(servicePair);
            }
        }
        resItemList.addAll(this.addGenericResources());
        rl.setResource(resItemList.toArray(new ResourceItem[0]));
        arp.setResources(rl);
        logger.trace((Object)("missing services are " + missingServices.size()));
        SoftwareList serviceList = new SoftwareList();
        List<PackageItem> packageItems = this.retrieveSoftwareToDeploy(missingServices);
        if (packageItems.size() > 0) {
            serviceList.setSoftware(packageItems.toArray(new PackageItem[packageItems.size()]));
            logger.trace((Object)("adding hosts: " + Arrays.toString(ghnsToUse)));
            serviceList.setSuggestedTargetGHNNames(ghnsToUse);
            arp.setSoftware(serviceList);
        }
        arp.setTargetScope(this.targetScope);
        String reportId = this.ports.getBinder().addResources(arp);
        String report = this.getDeployReport(reportId);
        logger.info((Object)("is something failed ?" + Util.isSomethingFailed(report)));
        logger.trace((Object)("final deploy report is :  " + report));
        return !Util.isSomethingFailed(report);
    }

    private String getDeployReport(String reportId) throws Exception {
        String report = null;
        do {
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            report = this.ports.getReporter().getReport(reportId);
            this.getResource().getDeployReport().getFunctionalityDeployingReport().setResourceManagerReport(report);
            ReportFiller.reportElaboration(this.getResource().getDeployReport());
            this.getResource().store();
        } while (!Util.isDeploymentStatusFinished(report));
        return report;
    }

    private List<PackageItem> retrieveSoftwareToDeploy(Set<ServicePair> missingServices) throws Exception {
        ArrayList<PackageItem> packageItems = new ArrayList<PackageItem>();
        Dao serviceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Service.class);
        SelectArg serviceClassArg = new SelectArg();
        SelectArg serviceNameArg = new SelectArg();
        PreparedQuery preparedQuery = serviceDao.queryBuilder().where().eq("serviceClass", (Object)serviceClassArg).and().eq("serviceName", (Object)serviceNameArg).prepare();
        for (ServicePair sp : missingServices) {
            preparedQuery.setArgumentHolderValue(0, (Object)sp.getServiceClass());
            preparedQuery.setArgumentHolderValue(1, (Object)sp.getServiceName());
            List services = serviceDao.query(preparedQuery);
            if (services.size() == 0) {
                throw new Exception("service " + sp.getServiceClass() + " " + sp.getServiceName() + " not found in the IS");
            }
            Service latestService = null;
            for (Service service : services) {
                if (latestService != null) {
                    if (!Util.isVersionGreater(service.getPackageVersion(), latestService.getPackageVersion())) continue;
                    latestService = service;
                    continue;
                }
                latestService = service;
            }
            PackageItem pi = new PackageItem();
            pi.setPackageName(latestService.getPackageName());
            pi.setPackageVersion(latestService.getPackageVersion());
            pi.setServiceClass(latestService.getServiceClass());
            pi.setServiceName(latestService.getServiceName());
            pi.setServiceVersion(latestService.getVersion());
            logger.trace((Object)("adding missing ri " + latestService.getServiceClass() + " " + latestService.getServiceName()));
            packageItems.add(pi);
        }
        return packageItems;
    }

    private void createScope(ScopeControllerPortType scopeControllerPT) throws Exception {
        CreateScopeParameters scopeParameter = new CreateScopeParameters();
        logger.trace((Object)("create scope with target scope " + this.targetScope));
        OptionsParameters optionParameters = new OptionsParameters(new ScopeOption[]{new ScopeOption("designer", this.vre.getVreDesigner()), new ScopeOption("manager", this.vre.getVreManager()), new ScopeOption("description", this.vre.getDescription()), new ScopeOption("endTime", KGCUBEResource.toXMLDateAndTime((Date)this.vre.getIntervalTo().getTime())), new ScopeOption("startTime", KGCUBEResource.toXMLDateAndTime((Date)this.vre.getIntervalFrom().getTime()))}, this.targetScope);
        scopeParameter.setOptionsParameters(optionParameters);
        scopeParameter.setTargetScope(this.targetScope);
        scopeControllerPT.createScope(scopeParameter);
    }

    private List<ResourceItem> addGenericResources() throws Exception {
        ArrayList<ResourceItem> resItemList = new ArrayList<ResourceItem>();
        Dao grDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), GenericResource.class);
        for (GenericResource gr : grDao.queryForAll()) {
            if (!ServiceContext.getContext().getSecondaryTypeGenericResourceRequired().contains(gr.getType())) continue;
            ResourceItem resItem = new ResourceItem();
            resItem.setID(gr.getId());
            resItem.setType(gr.getResourceType());
            resItemList.add(resItem);
            ReportFiller.addResourceToReport(gr.getId(), gr.getResourceType(), this.getResource().getDeployReport().getResourceDeployingReport());
            logger.trace((Object)("adding generic resource: " + gr.getId() + " " + gr.getResourceType()));
        }
        return resItemList;
    }
}

