/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.consumers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.resources.handlers.GHNHandler;

public class GHNConsumer
extends ISNotifier.BaseNotificationConsumer {
    public static ISNotifier.GCUBENotificationTopic ghnTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GHN"));
    private GCUBELog logger = new GCUBELog(GHNConsumer.class);
    private GCUBEScope scope;

    public GHNConsumer(GCUBEScope scope) {
        this.scope = scope;
    }

    public void onNotificationReceived(ISNotifier.NotificationEvent event) {
        try {
            ServiceContext.getContext().setScope(this.scope);
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            Dao ghnDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Ghn.class);
            if (operation.equals("update")) {
                GCUBEHostingNode gcubeHostingNode = (GCUBEHostingNode)GHNContext.getImplementation(GCUBEHostingNode.class);
                String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                gcubeHostingNode.load((Reader)new StringReader(profile));
                if (ghnDao.idExists((Object)gcubeHostingNode.getID())) {
                    if (gcubeHostingNode.getNodeDescription().getStatus() != GHNContext.Status.CERTIFIED) {
                        new GHNHandler().drop(gcubeHostingNode.getID());
                    }
                } else if (gcubeHostingNode.getNodeDescription().getStatus() == GHNContext.Status.CERTIFIED) {
                    Ghn ghn = new Ghn(gcubeHostingNode.getID(), gcubeHostingNode.getNodeDescription().getName(), gcubeHostingNode.getSite().getLocation(), gcubeHostingNode.getSite().getCountry(), gcubeHostingNode.getSite().getDomain(), gcubeHostingNode.getNodeDescription().getMemory().getAvailable(), gcubeHostingNode.getNodeDescription().getLocalAvailableSpace(), false);
                    ghn.setSecurityEnabled(gcubeHostingNode.getNodeDescription().isSecurityEnabled());
                    new GHNHandler().add(ghn);
                }
            } else if (operation.equals("destroy")) {
                this.logger.trace((Object)"removing a GHN from DB");
                new GHNHandler().drop(id);
            } else if (operation.equals("create")) {
                GCUBEHostingNode gcubeHostingNode = (GCUBEHostingNode)GHNContext.getImplementation(GCUBEHostingNode.class);
                String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                gcubeHostingNode.load((Reader)new StringReader(profile));
                if (gcubeHostingNode.getNodeDescription().getStatus() == GHNContext.Status.CERTIFIED && !ghnDao.idExists((Object)gcubeHostingNode.getID())) {
                    Ghn ghn = new Ghn(gcubeHostingNode.getID(), gcubeHostingNode.getNodeDescription().getName(), gcubeHostingNode.getSite().getLocation(), gcubeHostingNode.getSite().getCountry(), gcubeHostingNode.getSite().getDomain(), gcubeHostingNode.getNodeDescription().getMemory().getAvailable(), gcubeHostingNode.getNodeDescription().getLocalAvailableSpace(), false);
                    ghn.setSecurityEnabled(gcubeHostingNode.getNodeDescription().isSecurityEnabled());
                    new GHNHandler().add(ghn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error in notification received", (Throwable)e);
        }
    }

    static {
        ghnTopic.setUseRenotifier(false);
    }
}

