/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.image;

import java.io.FileFilter;
import java.lang.reflect.Method;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;
import org.gcube.vremanagement.virtualplatform.image.PlatformLoader;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;
import org.gcube.vremanagement.virtualplatform.model.TargetPlatform;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;

public class VirtualPlatform {
    GCUBELog logger = new GCUBELog(VirtualPlatform.class);
    TargetPlatform<?> container;
    PlatformLoader cl;
    PlatformConfiguration configuration;

    public VirtualPlatform(PlatformConfiguration configuration) throws Exception {
        this.configuration = configuration;
        try {
            this.cl = new PlatformLoader(configuration.getResources());
            Class<?> o2 = this.getClass().getClassLoader().loadClass("org.gcube.vremanagement.virtualplatform.model.TargetPlatform");
            if (o2 == null) {
                System.out.println("target platform is null");
            } else {
                System.out.println("TargetPlatform was loaded using this classloader: " + o2.getClassLoader().toString());
            }
            Object o = this.cl.getInstanceOf(configuration.getPlatformClass(), new Object[0]);
            if (o != null) {
                System.out.println("Container was loaded using this classloader: " + o.getClass().getClassLoader().toString());
            }
            this.logger.trace((Object)("I'm using this classloader: " + o.getClass().getClassLoader().toString()));
            if (!(o instanceof TargetPlatform)) {
                this.logger.error((Object)("The loaded platform is an instance of " + o.getClass().getName()));
                throw new Exception("The loaded platform does not implements the Target Platform interface");
            }
            this.container = (TargetPlatform)o;
            this.container.setBaseURL(configuration.getBaseURL());
            this.container.setUser(configuration.getUser());
            this.container.setPassword(configuration.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.fatal((Object)("Unable to initialize the virtual platform " + configuration.getName()), (Throwable)e);
            throw e;
        }
    }

    public Package getNewAppInstance() throws Exception {
        Package app = null;
        try {
            app = (Package)this.cl.getInstanceOf(this.container.getResourceClass().getName(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to get a new application instance from the platform", (Throwable)e);
            throw e;
        }
        return app;
    }

    public PackageSet<DeployedPackage> deploy(PackageSet<Package> packages) throws Exception {
        PackageSet<DeployedPackage> deployedPackages = new PackageSet<DeployedPackage>();
        try {
            Method m = this.container.getClass().getMethod("deploy", this.container.getResourceClass());
            for (Package p : packages) {
                try {
                    this.logger.info((Object)("Deploying package on platform " + this.configuration.getName()));
                    deployedPackages.add((DeployedPackage)m.invoke(this.container, p));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)"Failed to deploy ", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Invalid platform", e);
        }
        return deployedPackages;
    }

    public FileFilter getAcceptedFilesFilter() throws Exception {
        try {
            Method m = this.container.getClass().getMethod("getAcceptedFilesFilter", this.container.getResourceClass());
            return (FileFilter)m.invoke(this.container, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PackageSet<UndeployedPackage> undeploy(PackageSet<?> packages) throws Exception {
        PackageSet<UndeployedPackage> undeployedPackages = new PackageSet<UndeployedPackage>();
        try {
            Method m = this.container.getClass().getMethod("undeploy", this.container.getResourceClass());
            for (Object p : packages) {
                try {
                    this.logger.info((Object)("Undeploying package from platform " + this.configuration.getName()));
                    undeployedPackages.add((UndeployedPackage)m.invoke(this.container, p));
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to undeploy ", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid platform", e);
        }
        return undeployedPackages;
    }

    public boolean activate(PackageSet<?> packages) throws Exception {
        try {
            Method m = this.container.getClass().getMethod("activate", this.container.getResourceClass());
            for (Object p : packages) {
                try {
                    this.logger.info((Object)("Activating resource in platform " + this.configuration.getName()));
                    Boolean ret = (Boolean)m.invoke(this.container, p);
                    if (ret.booleanValue()) continue;
                    this.logger.info((Object)("Failed to activate the resource in platform " + this.configuration.getName()));
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to activate ", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid platform", e);
        }
        return true;
    }

    public boolean deactivate(PackageSet<?> packages) throws Exception {
        try {
            Method m = this.container.getClass().getMethod("deactivate", this.container.getResourceClass());
            for (Object p : packages) {
                try {
                    this.logger.info((Object)("Deactivating resource in platform " + this.configuration.getName()));
                    Boolean ret = (Boolean)m.invoke(this.container, p);
                    if (ret.booleanValue()) continue;
                    this.logger.info((Object)("Failed to deactivate the resource in platform " + this.configuration.getName()));
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to deactivate ", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid platform", e);
        }
        return true;
    }

    public void initialize() throws Exception {
        Method m = this.container.getClass().getMethod("initialize", new Class[0]);
        m.invoke(this.container, new Object[0]);
    }

    public void shutdown() throws Exception {
        Method m = this.container.getClass().getMethod("shutdown", new Class[0]);
        m.invoke(this.container, new Object[0]);
    }

    public boolean isAvailable() {
        try {
            Method m = this.container.getClass().getMethod("isAvailable", new Class[0]);
            return (Boolean)m.invoke(this.container, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to check if the platform is available or not", (Throwable)e);
            return false;
        }
    }

    public String getName() {
        return this.configuration.getName();
    }

    public short getVersion() {
        return this.configuration.getVersion();
    }

    public short getMinorVersion() {
        return this.configuration.getMinorVersion();
    }
}

