package org.gcube.vremanagement.virtualplatform.tomcat;

import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;

/**
 * 
 * A undeployed Web Application
 *
 * @author Manuele Simi (ISTI-CNR)
 *
 */
public class UndeployedWebapp implements UndeployedPackage {

	private Webapp app;
	boolean success = false;
	
	public UndeployedWebapp(Webapp app) {
		this.app = app;	
	}

	@Override
	public boolean isSuccess() {
		return this.success;
	}

	@Override
	public boolean verify() {
		return false;
	}	

	@Override
	public Package getSourcePackage() {
		return this.app;
	}
	
	public void setSuccess(boolean success) {
		this.success = success;
	}
	
}
