/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwarerepository.stubs.testsuite;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.vremanagement.softwarerepository.stubs.SoftwareRepositoryPortType;
import org.gcube.vremanagement.softwarerepository.stubs.service.SoftwareRepositoryServiceAddressingLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeleteTest {
    private static String scope = "/gcube/testing";

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage:");
            System.out.println("\tjava  DeleteTest  SoftwareRepositoryEPR  pendingXMLFileName  scope[default:/gcube/testing] \n\n");
            System.out.println("Example:");
            System.out.println("\tjava  DeleteTest http://grid6.4dsoft.hu:8080/wsrf/services/gcube/vremanagement/softwarerepository/SoftwareRepository  pending.xml  /gcube/testing \n\n");
            return;
        }
        File pendingFile = new File(args[1]);
        if (!pendingFile.exists()) {
            System.out.println("Thw xml file with pending archive to delete does NOT exists");
            return;
        }
        if (args.length == 3) {
            scope = args[2];
        }
        GCUBEScope gCubeScope = GCUBEScope.getScope((String)scope);
        EndpointReferenceType epr = new EndpointReferenceType();
        String serviceURI = args[0];
        try {
            epr.setAddress(new AttributedURI(serviceURI));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            return;
        }
        SoftwareRepositoryServiceAddressingLocator locator = new SoftwareRepositoryServiceAddressingLocator();
        SoftwareRepositoryPortType portType = null;
        try {
            portType = locator.getSoftwareRepositoryPortTypePort(epr);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        try {
            portType = (SoftwareRepositoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)portType, (GCUBEScope)gCubeScope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        List<String> ids = null;
        try {
            ids = DeleteTest.parseXMLPendingSoftwareArchives(pendingFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\n\n");
        for (int k = 0; k < ids.size(); ++k) {
            try {
                portType.delete(ids.get(k));
                System.out.println(ids.get(k) + ": Successfull Removed\n\n");
                continue;
            }
            catch (Exception e) {
                System.out.println("Error removing service with ID: " + ids.get(k) + "\n\n");
            }
        }
    }

    private static String fileToString(String absolutePath) throws Exception {
        BufferedReader filebuf = null;
        String nextStr = null;
        StringBuilder ret = new StringBuilder();
        try {
            filebuf = new BufferedReader(new FileReader(absolutePath));
            nextStr = filebuf.readLine();
            while (nextStr != null) {
                ret.append(nextStr);
                nextStr = filebuf.readLine();
            }
            filebuf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return ret.toString();
    }

    private static List<String> parseXMLPendingSoftwareArchives(File pendingFile) throws Exception {
        String xml;
        try {
            xml = DeleteTest.fileToString(pendingFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        ArrayList<String> ret = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw e;
        }
        Document document = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xml.getBytes());
            document = db.parse(byteArrayInputStream);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        Element root = document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("Service");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            String id = el.getElementsByTagName("Id").item(0).getTextContent();
            System.out.println("ID n. " + i + " = " + id);
            ret.add(id);
        }
        return ret;
    }
}

