/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.softwaregateway.client.SGAccessLibrary;
import org.gcube.vremanagement.softwaregateway.client.fws.Types;
import org.gcube.vremanagement.softwaregateway.client.proxies.Proxies;

public class DepSolverClient {
    public static void main(String[] args) {
        SGAccessLibrary library;
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 7 && args.length != 5) {
            System.out.println("Usage:");
            System.out.println("\tjava  DepSolverClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion   PackageName   PackageVersion\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  DepSolverClient  http://dlib25.isti.cnr.it:8080/wsrf/services/gcube/vremanagement/softwaregateway/Access  /gcube/devsec sn sc sv pn pv  \n\n");
            return;
        }
        ScopeProvider.instance.set(args[1]);
        try {
            library = (SGAccessLibrary)Proxies.accessService().at(new URI(args[0])).withTimeout(1, TimeUnit.MINUTES).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        String serviceClass = args[2];
        String serviceName = args[3];
        String serviceVersion = args[4];
        String packageName = null;
        String packageVersion = null;
        if (args.length == 7) {
            packageName = args[5];
            packageVersion = args[6];
        }
        Types.DependenciesCoordinates pc = new Types.DependenciesCoordinates();
        pc.pn = packageName;
        pc.pv = packageVersion;
        pc.sc = serviceClass;
        pc.sn = serviceName;
        pc.sv = serviceVersion;
        String xml = null;
        xml = library.getDependencies(pc);
        System.out.println("Dependencies founded: \n" + xml);
    }
}

