/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.coordinates;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.is.ISProxy;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;

public class MavenCoordinates
extends Coordinates {
    private GCubeCoordinates gcubeCoordinates;
    protected final GCUBELog logger = new GCUBELog(MavenCoordinates.class);

    public MavenCoordinates(String gId, String aId, String v) throws BadCoordinatesException {
        if (gId == null || gId.length() <= 0) {
            throw new BadCoordinatesException();
        }
        this.setGroupId(gId);
        if (aId == null || aId.length() <= 0) {
            throw new BadCoordinatesException();
        }
        this.setArtifactId(aId);
        this.setVersion(v);
    }

    @Override
    public Coordinates convert() throws BadCoordinatesException {
        this.gcubeCoordinates = new GCubeCoordinates(this.artifactId, this.groupId, "1.0.0", this.artifactId, this.version);
        return this.gcubeCoordinates;
    }

    public GCubeCoordinates getGcubeCoordinates() throws ServiceNotAvaiableFault {
        this.logger.trace((Object)"getGcubeCoordinates() method");
        this.logger.info((Object)("try to convert from maven to gcube: gid: " + this.getGroupId() + " aid " + this.getArtifactId() + " v" + this.getVersion()));
        if (this.gcubeCoordinates == null) {
            GCUBEScope scope = ServiceContext.getContext().getScope();
            ISProxy is = new ISProxy(scope, false);
            try {
                this.gcubeCoordinates = is.getGcubeCoordinates(this);
            }
            catch (Exception e) {
                try {
                    this.convert();
                }
                catch (BadCoordinatesException e1) {
                    throw new ServiceNotAvaiableFault("impossible convert coordinate frm maven to gcube");
                }
            }
        }
        return this.gcubeCoordinates;
    }

    public void setGcubeCoordinates(GCubeCoordinates gcubeCoordinates) {
        this.gcubeCoordinates = gcubeCoordinates;
    }
}

