/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.FileUtilsExtended;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenDependenciesSolver;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.parsing.XmlParse;
import org.xml.sax.SAXException;

public class NexusRestConnector {
    private HttpClient client;
    private static final String TEMPORARY_POM_FILE_NAME = "pom.xml";
    protected final GCUBELog logger = new GCUBELog(NexusRestConnector.class);

    public NexusRestConnector() {
        this.logger.debug((Object)"try to istantiate httpClient");
        this.getClient();
        this.logger.debug((Object)"Http Client instantiated ");
    }

    private HttpClient getClient() {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        return this.client;
    }

    public void searchAllRepoMavenInfo(String baseUrl) {
        this.client = this.getClient();
        String url = String.valueOf(baseUrl) + "/service/local/all_repositories";
        GetMethod method = new GetMethod(url);
        this.connect(method);
    }

    public String searchArtifact(String baseUrl, String groupName, String artifact, String extension, String ver, boolean pom) throws MalformedURLException {
        this.logger.trace((Object)("searchArtifact method from " + baseUrl + " with coordinates gId: " + groupName + " aId: " + artifact + " version: " + ver + " and extension: " + extension));
        this.client = this.getClient();
        String url = String.valueOf(baseUrl) + "/service/local/data_index/repo_groups/mycompany/content?g=" + groupName.trim() + "&a=" + artifact.trim();
        this.logger.debug((Object)("GETMETHOD url: " + url));
        GetMethod method = new GetMethod(url);
        String xml = this.connect(method);
        XmlParse p = new XmlParse();
        String artifactUrl = null;
        try {
            artifactUrl = p.getURlFromSearch(xml, groupName, artifact, extension, ver, pom, "servicearchive");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (artifactUrl != null) {
            return artifactUrl;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String connect(GetMethod method) {
        String result = null;
        try {
            try {
                int statusCode = this.getClient().executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusCode());
                }
                byte[] responseBody = method.getResponseBody();
                result = new String(responseBody);
            }
            catch (HttpException e) {
                this.logger.error((Object)("Fatal protocol violation: " + e.getMessage()));
                e.printStackTrace();
                method.releaseConnection();
            }
            catch (IOException e1) {
                this.logger.error((Object)("Fatal transport error: " + e1.getMessage()));
                e1.printStackTrace();
                method.releaseConnection();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private void connectAndDownload(GetMethod method, String path) {
        try {
            try {
                int statusCode = this.getClient().executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusCode());
                }
                byte[] responseBody = method.getResponseBody();
                FileOutputStream os = new FileOutputStream(path);
                ((OutputStream)os).write(responseBody);
            }
            catch (HttpException e) {
                this.logger.error((Object)("Fatal protocol violation: " + e.getMessage()));
                e.printStackTrace();
                method.releaseConnection();
            }
            catch (IOException e) {
                this.logger.error((Object)("Fatal transport error: " + e.getMessage()));
                e.printStackTrace();
                method.releaseConnection();
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    void getArtifact(String baseUrl, String path) {
        String url = baseUrl;
        GetMethod method = new GetMethod(url);
        this.connectAndDownload(method, path);
    }

    public byte[] getAsByteArray(URL url) throws IOException {
        int len;
        this.logger.debug((Object)"getAsByteArray method ");
        URLConnection connection = url.openConnection();
        InputStream in = connection.getInputStream();
        int contentLength = connection.getContentLength();
        ByteArrayOutputStream tmpOut = contentLength != -1 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream(16384);
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) != -1) {
            tmpOut.write(buf, 0, len);
        }
        in.close();
        tmpOut.close();
        byte[] array = tmpOut.toByteArray();
        return array;
    }

    public String extractDepsFromPomByMavenEmb(byte[] pomByte, String[] repositorieServers) throws BadCoordinatesException, Exception {
        this.logger.debug((Object)"extractDepsFromPomByMavenEmb method");
        String cfgDir = String.valueOf((String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false})) + File.separator + System.currentTimeMillis() + "_" + Thread.currentThread().getId();
        File dir = new File(cfgDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File pomFile = this.byteToFile(cfgDir, TEMPORARY_POM_FILE_NAME, pomByte);
        String dependenciesList = null;
        int i = 0;
        while (i < repositorieServers.length) {
            this.logger.debug((Object)("Dependencies solver from server: " + repositorieServers[i]));
            dependenciesList = new MavenDependenciesSolver().dependenciesSolverFromPom(pomFile, dir, repositorieServers[i], "compile");
            if (dependenciesList != null) break;
            ++i;
        }
        if (dir.exists()) {
            FileUtilsExtended.recursiveDeleteDirectory(dir);
        }
        return dependenciesList;
    }

    public File byteToFile(String cfgDir, String fileName, byte[] data) {
        this.logger.debug((Object)" bytoToFile conversion ");
        File file = null;
        this.logger.debug((Object)("configDir: " + cfgDir));
        file = new File(cfgDir, fileName);
        file.deleteOnExit();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            fos.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info((Object)("newFile created: " + file.getAbsolutePath()));
        return file;
    }
}

