/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenConfiguration;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenExecutor;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenRequestBuilder;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenResultTreeParser;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenSettingsReader;

public class MavenDependenciesSolver {
    public static final String DEPENDENCY_RESOLUTION = "DependencyResolutionReport";
    public static final String RESOLVED_DEPENDECIES = "ResolvedDependencies";
    public static final String MISSING_DEPENDENCIES = "MissingDependencies";
    protected final GCUBELog logger = new GCUBELog(MavenDependenciesSolver.class);

    public String dependenciesSolverFromPom(File pomFile, File projectDir, String repository, String scope) throws Exception {
        File resultTree;
        block20: {
            Throwable e2;
            block21: {
                this.logger.debug((Object)"dependenciesSolverFromPom method ");
                this.logger.debug((Object)("try to create the following dir: " + projectDir.getAbsolutePath()));
                if (!projectDir.exists()) {
                    projectDir.mkdirs();
                }
                resultTree = new File(projectDir, "resultTree.txt");
                String[][] properties = new String[1][2];
                properties[0][0] = "outputFile";
                properties[0][1] = resultTree.getAbsolutePath();
                String goal = "dependency:tree";
                this.logger.debug((Object)("executing goals : " + goal + " with outputFile=" + properties[0][1]));
                MavenRequestBuilder builder = new MavenRequestBuilder();
                builder.setProjectFolder(projectDir).setPom(pomFile).setUserProperties(properties).execThisGoal(goal).useThisRepository(MavenConfiguration.getLocalRepository());
                try {
                    MavenExecutor.exec(builder.build(), MavenSettingsReader.getSettings(new File(MavenConfiguration.getUserSettingsFile())));
                    break block20;
                }
                catch (Throwable e2) {
                    try {
                        this.logger.error((Object)("error," + e2.getMessage()));
                        if (e2 instanceof LifecycleExecutionException) {
                            this.logger.debug((Object)" the exception is an istance of org.apache.maven.lifecycle.LifecycleExecutionException ");
                            LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException)e2;
                            if (lifecycleExecutionException.getCause() instanceof MultipleArtifactsNotFoundException) {
                                DefaultArtifact defaultArtifact;
                                MultipleArtifactsNotFoundException multipleArtifactsNotFoundException = (MultipleArtifactsNotFoundException)lifecycleExecutionException.getCause();
                                List resolvedArtifacts = multipleArtifactsNotFoundException.getResolvedArtifacts();
                                List missingArtifacts = multipleArtifactsNotFoundException.getMissingArtifacts();
                                if (resolvedArtifacts == null || missingArtifacts == null) break block21;
                                this.logger.info((Object)"entered in th first if ...");
                                StringBuffer sb = new StringBuffer();
                                sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
                                sb.append("<").append(RESOLVED_DEPENDECIES).append(">\n");
                                this.logger.info((Object)("the resolved dependencies are " + resolvedArtifacts.size()));
                                int j = 0;
                                while (j < resolvedArtifacts.size()) {
                                    defaultArtifact = (DefaultArtifact)resolvedArtifacts.get(j);
                                    this.logger.info((Object)("Resolved Artifact n. " + j + " : " + defaultArtifact));
                                    try {
                                        sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("Dependency", defaultArtifact));
                                    }
                                    catch (Exception e1) {
                                        this.logger.info((Object)e1);
                                        throw e1;
                                    }
                                    ++j;
                                }
                                sb.append("</").append(RESOLVED_DEPENDECIES).append(">\n");
                                sb.append("<").append(MISSING_DEPENDENCIES).append(">\n");
                                int k = 0;
                                while (k < missingArtifacts.size()) {
                                    defaultArtifact = (DefaultArtifact)missingArtifacts.get(k);
                                    this.logger.info((Object)("Missing Artifact n. " + k + " : " + defaultArtifact));
                                    try {
                                        sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("MissingDependency", defaultArtifact));
                                    }
                                    catch (Exception e1) {
                                        this.logger.info((Object)e1);
                                        e1.printStackTrace();
                                        throw e1;
                                    }
                                    ++k;
                                }
                                sb.append("</").append(MISSING_DEPENDENCIES).append(">\n");
                                sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                                return sb.toString();
                            }
                            if (!(lifecycleExecutionException.getCause() instanceof OverConstrainedVersionException)) break block21;
                            OverConstrainedVersionException cause = (OverConstrainedVersionException)lifecycleExecutionException.getCause();
                            DefaultArtifact defaultArtifact = (DefaultArtifact)cause.getArtifact();
                            StringBuffer sb = new StringBuffer();
                            sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
                            sb.append("<").append(MISSING_DEPENDENCIES).append(">\n");
                            try {
                                this.logger.info((Object)("Missing Artifact  : " + defaultArtifact));
                                sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("MissingDependency"));
                            }
                            catch (Exception e1) {
                                this.logger.info((Object)e1);
                                throw e1;
                            }
                            sb.append("</").append(MISSING_DEPENDENCIES).append(">\n");
                            sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                            this.logger.info((Object)("OUT:    " + sb.toString()));
                            sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                            return sb.toString();
                        }
                        this.logger.debug((Object)" the exception is not an istance of org.apache.maven.lifecycle.LifecycleExecutionException ");
                    }
                    catch (Exception pe) {
                        this.logger.error((Object)"null pointer Exception", (Throwable)pe);
                    }
                }
            }
            throw new Exception(e2);
        }
        try {
            this.logger.info((Object)"Parsing dependency tree");
            MavenResultTreeParser treeParser = new MavenResultTreeParser(resultTree);
            treeParser.getScopedDependecy(scope);
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
            sb.append(treeParser.listDependency());
            sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
            this.logger.info((Object)("OUT:    " + sb.toString()));
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info((Object)("error," + e.getMessage()));
            throw e;
        }
        finally {
            this.logger.info((Object)(projectDir.getAbsoluteFile() + " not removed for debug issue"));
        }
    }
}

