/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.is;

import java.io.StringReader;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.is.ISCache;
import org.gcube.vremanagement.softwaregateway.impl.is.ISManager;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.packages.MavenPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISProxy
extends ISManager {
    private ISCache cache;

    public ISProxy(GCUBEScope gCubeScope, boolean cacheEnabled) {
        super(gCubeScope);
        this.logger.trace((Object)"creating IS proxy...");
        this.cacheEnabled = cacheEnabled;
        if (cacheEnabled) {
            this.logger.trace((Object)"cache is enabled");
            this.cache = ISCache.getInstance();
        }
    }

    @Override
    public MavenCoordinates getMavenCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getMavenCoordinates method ");
        MavenCoordinates mCoordinates = null;
        if (mCoordinates == null && (mCoordinates = this.queryMavenCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, mCoordinates);
        }
        return mCoordinates;
    }

    public MavenCoordinates getSAMavenCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getSAMavenCoordinates method ");
        MavenCoordinates mCoordinates = null;
        if (mCoordinates == null) {
            mCoordinates = this.querySAMavenCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion());
        }
        return mCoordinates;
    }

    public GCubeCoordinates getGcubeCoordinates(MavenCoordinates mavenC) throws ISException, BadCoordinatesException {
        GCubeCoordinates gCoordinates = null;
        if (this.cacheEnabled) {
            gCoordinates = this.cache.getGcubeCoordinates(mavenC);
        } else {
            this.logger.info((Object)"Cache not enabled");
        }
        if (gCoordinates == null) {
            gCoordinates = this.queryGCubeCoordinates(mavenC.getGroupId(), mavenC.getArtifactId(), mavenC.getVersion());
            if (gCoordinates != null) {
                this.logger.info((Object)("gcube coordinates founded: sc " + gCoordinates.getServiceClass() + " sn " + gCoordinates.getServiceName() + " sv " + gCoordinates.getPackageName() + " "));
            }
            if (gCoordinates != null && this.cacheEnabled) {
                this.logger.info((Object)"CACHE ELEMENT INSERTED");
                this.cache.put(mavenC, gCoordinates);
            }
        }
        return gCoordinates;
    }

    @Override
    public void updateProfile(String xml) {
    }

    @Override
    public List<URL> getMavenConfiguration() {
        List<URL> list = null;
        return list;
    }

    public String[] getMavenServerList(GCUBEScope scope) throws Exception {
        this.logger.trace((Object)("getMavenServerList method call for retrieve server list from scope: " + scope.getName()));
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)this.getIsClient().getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Name", "SoftwareGateway")});
        for (GCUBEGenericResource resource : this.isClient.execute((ISQuery)query, scope)) {
            String body = resource.getBody();
            this.server = this.parseXmlFile(new InputSource(new StringReader(body)));
        }
        if (this.server != null) {
            this.logger.debug((Object)("server founded: " + this.server.length));
            String[] stringArray = this.server;
            int n = this.server.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.logger.debug((Object)("server: " + s));
                ++n2;
            }
            this.logger.info((Object)("number of servers : " + this.server.length));
        }
        if (this.server == null || this.server.length == 0) {
            this.logger.info((Object)"server not found try in enclosing scope if it is a VRE scope");
            GCUBEScope.Type scopeType = scope.getType();
            this.logger.info((Object)("scope type: " + GCUBEScope.Type.VRE + " equals to  " + GCUBEScope.Type.VRE));
            if (GCUBEScope.Type.VRE == GCUBEScope.Type.VRE) {
                this.logger.info((Object)"VRE scope try enclosing scope");
                GCUBEScope newScope = scope.getEnclosingScope();
                this.logger.info((Object)("enclosing scope founded: " + newScope));
                if (newScope != null) {
                    this.server = this.getMavenServerList(newScope);
                } else {
                    return this.server;
                }
            }
        }
        return this.server;
    }

    private String[] parseXmlFile(InputSource body) {
        String[] list = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(body);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("server_list");
            int i = 0;
            list = new String[nodeLst.getLength()];
            int s = 0;
            while (s < nodeLst.getLength()) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() == 1) {
                    String ip;
                    Element fstElmnt = (Element)fstNode;
                    NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("server");
                    Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
                    list[i] = ip = fstNmElmnt.getAttribute("url");
                    ++i;
                }
                ++s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<MavenPackage> getMavenPackagesCoordinates(GCubeCoordinates gcubeC) throws ISException {
        List<MavenPackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getMavenPackagesCoordinates(gcubeC);
        }
        if (coordList == null && (coordList = this.queryMavenPackagesCoordinates(gcubeC.getServiceName(), gcubeC.getServiceClass(), gcubeC.getServiceVersion(), gcubeC.getPackageName(), gcubeC.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(gcubeC, coordList);
        }
        return coordList;
    }

    public List<GCubePackage> getGCubePackagesCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getGCUbePackagesCoordinates method");
        List<GCubePackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getGCubePackagesCoordinates(coordinates);
        }
        if (coordList == null && (coordList = this.queryGCubePackagesCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, coordList);
        }
        return coordList;
    }

    @Override
    public List<GCubePackage> getPluginCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)" getPlugin method");
        List<GCubePackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getPluginCoordinates(coordinates);
        }
        if (coordList == null && (coordList = this.queryPluginCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, coordList);
        }
        return coordList;
    }
}

