/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gcube.common.core.utils.logging.GCUBELog;

public class MavenEmbedder {
    private final Maven maven;
    private final MavenExecutionRequestPopulator populator;
    final String mavenCoreRealmId = "gcube.maven.core";
    private final GCUBELog logger = new GCUBELog(MavenEmbedder.class);

    public MavenEmbedder() throws ComponentLookupException, PlexusContainerException {
        DefaultContainerConfiguration cc = new DefaultContainerConfiguration();
        DefaultPlexusContainer plexus = new DefaultPlexusContainer((ContainerConfiguration)cc);
        this.populator = (MavenExecutionRequestPopulator)plexus.lookup(MavenExecutionRequestPopulator.class);
        this.maven = (Maven)plexus.lookup(Maven.class);
        System.out.println("Maven is instance of " + this.maven.getClass().getName());
    }

    public MavenExecutionResult execute(MavenExecutionRequest request, Settings settings) {
        DefaultMavenExecutionResult result;
        if (request == null) {
            throw new IllegalArgumentException("Maven request can't be null");
        }
        try {
            this.populator.populateFromSettings(request, settings);
            System.out.println("ACTIVE PROFILE: " + request.getActiveProfiles().toString());
            for (Profile profile : request.getProfiles()) {
                for (Repository rep : profile.getRepositories()) {
                    System.out.println("ACTIVE REPOSITORY Id: " + rep.getId());
                    System.out.println("ACTIVE REPOSITORY URL: " + rep.getUrl());
                }
            }
            result = this.maven.execute(request);
        }
        catch (MavenExecutionRequestPopulationException ex) {
            this.logger.error((Object)"Error while populating the Maven Request", (Throwable)ex);
            result = new DefaultMavenExecutionResult();
            result.addException((Throwable)ex);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            result = new DefaultMavenExecutionResult();
            result.addException((Throwable)e);
        }
        return result;
    }
}

