package org.gcube.vremanagement.softwaregateway.impl.repositorymanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.is.ISProxy;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache.NexusCache;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.parsing.XmlParse;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArchiveManagement;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.NexusRestConnector;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.FileUtilsExtended;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class NexusRepositoryManager extends RepositoryManager {

	public static final String TEMPORARY_SA_FILE_NAME="sa_tar_file.tar.gz";
	protected final GCUBELog logger = new GCUBELog(NexusRepositoryManager.class);
	private HttpClient client;
	public NexusCache cache=null;
	public static NexusRepositoryManager singleton;
	
	
	public NexusRepositoryManager(String[] mavenServerList, boolean cacheEnabled) {
		super(mavenServerList);
		this.cacheEnabled=cacheEnabled;
		if(cacheEnabled)
			cache=NexusCache.getInstance(mavenServerList);
	}

	
	public String get(Object mavenC, String extension, String classifier) throws MalformedURLException, ServiceNotAvaiableFault{
		logger.debug("get method: get maven object with extension "+extension+"");	
		MavenCoordinates mc=(MavenCoordinates)mavenC;
		logger.debug("mavenCoordinates "+mc.getGroupId()+" "+mc.getArtifactId()+" "+mc.getVersion());
		if(mc!=null){
//			MavenCoordinates mc=mcList.get(0);
//			logger.debug("coordinates: "+mc.getGroupId()+" "+mc.getArtifactId()+" "+mc.getVersion());
			String url=null;
			if(cacheEnabled){
				logger.debug("cache enabled ");
				url=cache.get(mavenC, extension, classifier);
			}
			if(url!=null){
				logger.debug("url found in cache");
				return url;
			}
				
			logger.debug("and coordinates: g: "+mc.getGroupId()+ " a: "+mc.getArtifactId()+" v: "+mc.getVersion());
			if(servers == null)
				logger.debug(" list of servers is null ");
			else
				logger.debug("list of servers is not null "+servers);
			logger.debug("number of servers founded: "+servers.length);
			for(int i=0; i<servers.length; i++){
				logger.debug(" get method search artifact: "+mc.getArtifactId()+"  with extension: "+extension);
				if(extension.equalsIgnoreCase("pom"))
					url=searchArtifact(servers[i], mc.getGroupId(), mc.getArtifactId(), "jar", mc.getVersion(), true, classifier);
				else
					url=searchArtifact(servers[i], mc.getGroupId(), mc.getArtifactId(), extension, mc.getVersion(), false, classifier);
				if((url !=null && !url.isEmpty()) && (cacheEnabled)){
					String cacheCoordinates=cache.buildMavenCoordinatesCacheInputString(mc, extension, classifier);
					cache.put(cacheCoordinates, url);
					break;
				}
			}
			logger.debug("get Method url returned: "+url);
			if(url==null)
				throw new ServiceNotAvaiableFault("url is null ");
			return url;
		}else{
			logger.debug("invalid maven coordinates");
			return null;
		}
	}

	
	/**
	 * Download pom file and extract Dependencies from maven repositories
	 * @param url: url of the pom file
	 */
	@Override
	public String extractDepsFromMavenEmb(String url) throws ServiceNotAvaiableFault{
		logger.debug("extractDepsFromMavenEmb method with url: "+url);
		NexusRestConnector nc=new NexusRestConnector();
		String result=null;
		if(cacheEnabled)
			result=cache.extractDepsFromMavenEmb(url);
		if(result != null)
			return result;
	//recover pom file from url	
		try{
			byte[] pom=nc.getAsByteArray(new URL(url));
			logger.debug("pom converted in byte array");
			logger.debug("extract deps from pom: "+pom+" and first server"+servers[0]);
			result=nc.extractDepsFromPomByMavenEmb(pom, servers);
			if(cacheEnabled)
				cache.put(url, result);
			return result;
		}catch(Exception e){
			throw new ServiceNotAvaiableFault(e.getMessage());
		}
	}
	
	
	
	private File downloadSA(File targetDirectory, String fromURL) throws IOException{
		logger.debug("Trying to download Archive from: " + fromURL + ", to = " + targetDirectory);
		if(targetDirectory.exists()){
			logger.debug ("Deleting old tmp directory" + "\ntmp directory path = " +  targetDirectory.getAbsolutePath());
			FileUtilsExtended.recursiveDeleteDirectory(targetDirectory);
		}
		logger.debug ("Creating tmp directory" + "\ntmp directory path = " +  targetDirectory.getAbsolutePath());
		targetDirectory.mkdirs();
		File archive = null;
		NexusRestConnector nc=new NexusRestConnector();
	//recover pom file from url	
		byte[] saByte=nc.getAsByteArray(new URL(fromURL));
    	String cfgDir= (String)ServiceContext.getContext().getProperty("configDir", false);
		File sa=nc.byteToFile(cfgDir, System.currentTimeMillis()+"-"+TEMPORARY_SA_FILE_NAME, saByte);
		return sa;
	}
	
	/**
	 * Search a maven object (pom, jar, tar.gz) from a maven repository
	 * @param baseUrl base url of a maven repository
	 * @param groupName groupID
	 * @param artifact artifactID
	 * @param extension type of extension: jar, pom, tar.gz
	 * @param ver version of the maven object 
	 * @param pom true if the maven object searched is a pom file
	 * @return the url of the maven object if founded otherwise null
	 * @throws MalformedURLException
	 */
	public String searchArtifact(String baseUrl, String groupName, String artifact, String extension, String ver, boolean pom, String classifier) throws MalformedURLException{
		logger.debug("searchArtifact method from "+baseUrl+ " with coordinates gId: "+groupName+" aId: "+artifact+" version: "+ver+" and extension: "+extension+" and classifier "+classifier);
		client = getClient();
		StringBuffer param=new StringBuffer();
		String artifactId=artifact;
		String classifierId=classifier;
		if(artifact.contains("#")){
			String[] splitting = artifact.split("\\#");
			artifactId =splitting[0];
			classifierId=splitting[1];
		}
		if(ver!=null)
			param.append("g="+groupName.trim()+"&a="+artifactId.trim()+"&v="+ver);
		else{
			param.append("g="+groupName.trim()+"&a="+artifactId.trim()+"&v=LATEST");
		}
		String localUrl=baseUrl+"/service/local/data_index/repo_groups/mycompany/content?"+param.toString();
		String centralUrl=null;
		centralUrl=baseUrl+"/service/local/artifact/maven/redirect?r=central&"+param.toString();
		logger.debug("getMethod with url: "+localUrl);
		GetMethod method=new GetMethod(localUrl);
		logger.debug("connect to server ");
    	String xml=connect(method);  
    	logger.debug(" server response: "+xml);
    	XmlParse p=new XmlParse();
    	String artifactUrl=null;
    	try {
    		artifactUrl=p.getURlFromSearch(xml, groupName, artifactId, extension, ver, pom, classifierId);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		}
		if(artifactUrl != null){
			return artifactUrl;
		}else{
// try to get the url without classifier only if the classifier is servicearchive. In this case i try to get the jar 	
			if(classifier.equalsIgnoreCase("servicearchive")){
				try {
		    		artifactUrl=p.getURlFromSearch(xml, groupName, artifactId, extension, ver, pom, null);
				} catch (IOException e) {
					e.printStackTrace();
				} catch (SAXException e) {
					e.printStackTrace();
				}
			}
			if(artifactUrl!=null)
				return artifactUrl;
			else{
				// check in maven central
				method=new GetMethod(centralUrl);
				try {
					int statusCode = getClient().executeMethod(method);
					if(statusCode == HttpStatus.SC_OK){
						logger.info("found artifact in maven Central, status code returned: "+statusCode);	
						return centralUrl;
					}
						
				} catch (HttpException e) {
					logger.error(" HttpException in maven Central "+e.getMessage());
				} catch (IOException e) {
					logger.error(" IOException in maven Central "+e.getMessage());
				}

			}
			
		}
		return null;	
	}

	
	private HttpClient getClient(){
		if(client == null)
			client = new HttpClient();
		return client;
	}

	/**
	 * return the server response (XML format)
	 * @param client
	 * @param method
	 */
	private String connect(GetMethod method) {
		logger.debug("Try to connect to the server: connect method");
		String result=null;
		try {
		      // Execute the method.
		      int statusCode = getClient().executeMethod(method);

		      if (statusCode != HttpStatus.SC_OK) {
		        logger.error("Method failed: " + method.getStatusCode());
		      }

		      // Read the response body.
		      byte[] responseBody = method.getResponseBody();

		      // Deal with the response.
		      // Use caution: ensure correct character encoding and is not binary data
		      result=new String(responseBody);
//		      System.out.println(result);

	    } catch (HttpException e) {
	      logger.error("Fatal protocol violation: " + e.getMessage());
	      e.printStackTrace();
	    } catch (IOException e1) {
	      logger.error("Fatal transport error: " + e1.getMessage());
	      e1.printStackTrace();
	    } catch (Exception e2){
	    	e2.printStackTrace();
	    }finally {
	      // Release the connection.
		  method.releaseConnection();
	    }
	    return result;
	}
	
	/**
	 * Download a maven object in the path specified in the input parameter
	 * @param path path where the maven object is downloaded
	 * @param method instance of a get method
	 */
	private void connectAndDownload(GetMethod method, String path) {
		try {
		      // Execute the method.
		      int statusCode =getClient().executeMethod(method);

		      if (statusCode != HttpStatus.SC_OK) {
		        System.err.println("Method failed: " + method.getStatusCode());
		      }

		      // Read the response body.
		      byte[] responseBody = method.getResponseBody();

		      OutputStream os=new FileOutputStream(path);
		      os.write(responseBody);
		} catch (HttpException e) {
	      logger.error("Fatal protocol violation: " + e.getMessage());
	      e.printStackTrace();
		} catch (IOException e) {
		      logger.error("Fatal transport error: " + e.getMessage());
	      e.printStackTrace();
		} finally {
		      // Release the connection.
			method.releaseConnection();
		}
	}
	


	
	/**
	 * create a local SA archive with only the package requested,
	 * re-tar the SA and put in a local (cachable folder)
	 * @param tmpTargetDirectory
	 * @param profile
	 * @param arcManager
	 * @return the URL from which the local SA can be downloaded
	 */
		private String getLocalSAURL(File tar, File profile, ArchiveManagement arcManager, Coordinates coordinates) {		
		//get http base dir	
//			initialize();
			tar.setExecutable(true);
			tar.setReadable(true);
			String relativePath=File.separator+coordinates.getServiceClass()+File.separator+coordinates.getServiceName()+File.separator+coordinates.getPackageName()+File.separator+coordinates.getPackageVersion();
			File urlDirectory = new File(ServiceContext.getContext().getHttpServerBasePath().getAbsolutePath() +File.separator+ ServiceContext.getContext().getMavenRelativeDir()+relativePath);
			if(!urlDirectory.exists()){
				boolean created= urlDirectory.mkdir();
				if (created)
					logger.debug("Directory "+urlDirectory.getAbsolutePath()+" created");
				else
					logger.warn("Directory "+urlDirectory.getAbsolutePath()+" not created");
			}
			urlDirectory.setWritable(true);
			urlDirectory.setExecutable(true);
			logger.debug("directory on the server is: "+urlDirectory.getAbsolutePath());
			try {
				logger.debug("copy file "+tar.getAbsolutePath()+" in directory: "+urlDirectory.getAbsolutePath());
				FileUtils.copyFileToDirectory(tar, urlDirectory);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
//			File archive=new File(urlDirectory.getAbsolutePath(), tar.getAbsolutePath());
			
			String hostName = GHNContext.getContext().getHostname();
			StringBuilder sb = new StringBuilder();
		// build url	
			sb.append("http://").append(hostName).append(":"+ServiceContext.getContext().getHttpServerPort()).append("/" + ServiceContext.getContext().getMavenRelativeDir()+relativePath +File.separator+tar.getName());
			logger.debug(" local url for sa created: "+sb.toString());
			return sb.toString();
		}

		
/**
 * @param tmpTargetDirectory
 * @param mcList
 * @return
 * @throws MalformedURLException
 * @throws ServiceNotAvaiableFault
 * @throws IOException
 * @throws Exception
 */
		
	@Override
	public String getSALocation(File tmpTargetDirectory, List mcList,
			Coordinates coordinates) throws MalformedURLException,
			ServiceNotAvaiableFault, IOException, Exception {
		logger.debug("getSALocation method ");
		String url=null;
		if(cacheEnabled)
			url=cache.getSALocation(tmpTargetDirectory, mcList, coordinates);
		if(url != null){
			logger.info("CACHE FETCHED "+url);
			return url;
		}
		logger.debug("not element retrieved in cache ");
		File sa;
		url=(String)get(mcList.get(0), "tar.gz", SERVICE_ARCHIVE_IDENTIFIER);	
/*SECTION FOR UPLOAD PROFILE E JETTY PUBLICATION*/		
//	//download archive	
//		sa=downloadSA(tmpTargetDirectory, url);
//	//TEST		
////		sa= new File (tmpTargetDirectory, NexusRepositoryManager.TEMPORARY_SA_FILE_NAME);
//	//ENDTEST		
//		ArchiveManagement arcManager=new ArchiveManagement();
//		arcManager.unTarGz(sa);
//	//retrieve profile	
//		File profile=arcManager.extractFileFromArchive(sa, "profile.xml");
////	if it contains not only the package identify by pn pv 
//		boolean onePackage=false; //verifyPackageNumber(mavenC );
//		if(!onePackage){
//			logger.debug("founded more than one package");
//			profile = new XmlParse().updateProfile(profile, coordinates);
//			arcManager.replaceFilesToTarGz(sa, profile);
//			url=getLocalSAURL(sa, profile, arcManager, coordinates);
//		}
/*END SECTION UPLOAD PROFILE*/		
		if((url != null) && (cacheEnabled)){
	// insert entry in cache
			logger.info("insert entry in cache ");
			String cacheString= cache.buildGCubeCoordinatesCacheInputString(coordinates, "tar.gz", "servicearchive");
			cache.put(cacheString, url);
		}
		return url;
	}

}
