/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.tar.TarEntry;
import org.apache.commons.compress.tar.TarInputStream;
import org.apache.commons.compress.tar.TarOutputStream;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.NexusRestConnector;

public class ArchiveManagement {
    protected static final GCUBELog logger = new GCUBELog(ArchiveManagement.class);

    public static void unTarGz(File sourceArchive) throws Exception {
        logger.debug((Object)("Uncompressing TAR GZ archive : " + sourceArchive.getAbsolutePath()));
        try {
            int len;
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(sourceArchive));
            String name = sourceArchive.getName();
            if (name.contains(".tar.gz")) {
                name = name.replace(".gz", "");
            } else if (name.contains(".tgz")) {
                name = name.replace("tgz", "tar");
            }
            File tarArchive = new File(sourceArchive.getParentFile(), name);
            FileOutputStream out = new FileOutputStream(tarArchive);
            byte[] buf = new byte[1024];
            logger.debug((Object)"Unzipping tar.gz file");
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            logger.debug((Object)"Untar TAR file");
            TarInputStream tis = new TarInputStream((InputStream)new FileInputStream(tarArchive));
            TarEntry te = null;
            while ((te = tis.getNextEntry()) != null) {
                logger.debug((Object)("Processing " + (te.isDirectory() ? "directory : " : "file : ") + te.getName()));
                File file = new File(sourceArchive.getParent(), te.getName());
                if (te.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                tis.copyEntryContents((OutputStream)new FileOutputStream(file));
            }
            tarArchive.delete();
            tis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to uncompress tar.gz", (Throwable)e);
            throw e;
        }
        logger.debug((Object)"TAR GZ file uncompressed successfully");
    }

    public static void createTarGz(File targetArchive, List<File> archiveFiles) throws Exception {
        File[] arrayArchiveFiles = new File[archiveFiles.size()];
        for (int i = 0; i < archiveFiles.size(); ++i) {
            arrayArchiveFiles[i] = archiveFiles.get(i);
        }
        ArchiveManagement.createTarGz(targetArchive, arrayArchiveFiles);
    }

    public static void createTarGz(File targetArchive, File[] archiveFiles) throws Exception {
        int len;
        String name;
        logger.debug((Object)"Creating TAR GZ file");
        File parentDirectory = targetArchive.getParentFile();
        File rootDirectory = null;
        if (archiveFiles[0].isDirectory()) {
            rootDirectory = archiveFiles[0];
        }
        if ((name = targetArchive.getName()).contains(".tar.gz")) {
            name = name.replace(".gz", "");
        } else if (name.contains(".tgz")) {
            name = name.replace("tgz", "tar");
        } else {
            Exception e = new Exception("The archive should have .tar.gz or .tgz extention");
            logger.error((Object)e);
            throw e;
        }
        File tarFile = new File(parentDirectory, name);
        logger.debug((Object)("Opening TAR file: " + tarFile.getName()));
        FileOutputStream stream = new FileOutputStream(tarFile);
        TarOutputStream out = new TarOutputStream((OutputStream)stream);
        out.setLongFileMode(2);
        byte[] buffer = new byte[1024];
        for (File item : archiveFiles) {
            int nRead;
            if (rootDirectory != null && item == rootDirectory) continue;
            logger.debug((Object)("Adding " + item.getName() + " to TAR"));
            TarEntry tarEntry = new TarEntry(item);
            String relativePath = item.getName();
            if (rootDirectory != null) {
                relativePath = item.getAbsolutePath().replace(rootDirectory.getAbsolutePath() + File.separator, "");
            }
            tarEntry.setName(relativePath);
            tarEntry.setSize(item.length());
            out.putNextEntry(tarEntry);
            FileInputStream in = new FileInputStream(item);
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
            out.closeEntry();
        }
        logger.debug((Object)("Closing TAR file: " + tarFile.getName()));
        out.close();
        stream.close();
        logger.debug((Object)("Compressing tar file = " + tarFile.getName()));
        String outFileName = tarFile.getAbsoluteFile() + ".gz";
        GZIPOutputStream outGZ = new GZIPOutputStream(new FileOutputStream(outFileName));
        FileInputStream inTAR = new FileInputStream(tarFile);
        while ((len = inTAR.read(buffer)) > 0) {
            outGZ.write(buffer, 0, len);
        }
        inTAR.close();
        outGZ.finish();
        outGZ.close();
        logger.debug((Object)"Deleting TAR file");
        logger.debug((Object)(tarFile.getName() + " " + (tarFile.delete() ? "deleted" : "not deleted")));
        logger.debug((Object)(targetArchive.getName() + " successfull created"));
    }

    public File extractFileFromArchive(File tar, String pathToFile) throws IOException {
        logger.debug((Object)"extractFileFromArchive method");
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(tar));
        TarInputStream tin = new TarInputStream((InputStream)gis);
        TarEntry te = tin.getNextEntry();
        while (!te.getName().equals(pathToFile)) {
            logger.debug((Object)("processing file: " + te.getName()));
            te = tin.getNextEntry();
        }
        logger.debug((Object)("file in archive founded: " + te.getName()));
        byte[] bytes = new byte[(int)te.getSize()];
        tin.read(bytes);
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        return new NexusRestConnector().byteToFile(cfgDir, pathToFile, bytes);
    }

    public void insertFileToArchive(File tar, String pathToFile) throws IOException {
        int buffersize = 1024;
        byte[] buf = new byte[buffersize];
        TarOutputStream tos = new TarOutputStream((OutputStream)new FileOutputStream(tar));
        File profile = new File(pathToFile);
        FileInputStream fis = new FileInputStream(profile);
        TarEntry te = new TarEntry(profile.getPath());
        tos.putNextEntry(te);
        int count = 0;
        while ((count = fis.read(buf, 0, buffersize)) != -1) {
            tos.write(buf, 0, count);
        }
        tos.closeEntry();
        fis.close();
    }

    public void replaceFilesToTarGz(File source, File file) {
        logger.debug((Object)"replaceFilesToTarGz method");
        try {
            File tmpZip = File.createTempFile(source.getName(), null);
            tmpZip.delete();
            if (!source.renameTo(tmpZip)) {
                throw new Exception("Could not make temp file (" + source.getName() + ")");
            }
            byte[] buffer = new byte[1024];
            GZIPInputStream gis = new GZIPInputStream(new FileInputStream(tmpZip));
            TarInputStream tin = new TarInputStream((InputStream)gis);
            GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(source));
            TarOutputStream out = new TarOutputStream((OutputStream)gos);
            out.setLongFileMode(2);
            FileInputStream in = new FileInputStream(file);
            TarEntry te = new TarEntry(file.getName());
            te.setSize(file.length());
            out.putNextEntry(te);
            int read = ((InputStream)in).read(buffer);
            while (read > -1) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
            out.closeEntry();
            ((InputStream)in).close();
            TarEntry tentry = tin.getNextEntry();
            while (tentry != null) {
                if (!tentry.getName().equals(file.getName())) {
                    out.putNextEntry(tentry);
                    int read2 = tin.read(buffer);
                    while (read2 > -1) {
                        out.write(buffer, 0, read2);
                        read2 = tin.read(buffer);
                    }
                    out.closeEntry();
                }
                tentry = tin.getNextEntry();
            }
            out.close();
            tmpZip.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

