package org.gcube.vremanagement.softwaregateway.impl.packages;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.NexusRepositoryManager;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.RepositoryManagerFactory;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache.NexusCache;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.parsing.XmlParse;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArchiveManagement;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;


public class GCubePackage extends Package {
	
	Coordinates coordinates;
	protected final GCUBELog logger = new GCUBELog(GCubePackage.class);
	
	public GCubePackage(Coordinates coordinates) throws BadCoordinatesException{
		setCoordinates(coordinates);
	}

/**
 * Retrieve location of Package	
 */
	@Override
	public String getLocation() throws ServiceNotAvaiableFault {
		logger.debug("GCubePackage, getLocation method");
		String url=null;
		initialize();
		try{
	// retrieve or convert in maven Coordinates		
			MavenCoordinates mavenC = getMavenCoordinates();
//			List<MavenCoordinates> mcList=new ArrayList<MavenCoordinates>();
//			mcList.add(mavenC);
	// Call to RepositoryManager with maven coordinates
			RepositoryManagerFactory rmf= new RepositoryManagerFactory();		
			rm= rmf.getRepositoryManager(is.getMavenServerList(scope), true);
			url=(String)rm.get(mavenC, "jar", "servicearchive");			
			logger.debug(" url of jar founded: "+url);
		}catch(Exception e){
			throw new ServiceNotAvaiableFault(e.getMessage());
		}finally{
			if(url==null)
				throw new ServiceNotAvaiableFault("url is null ");
		}
		return url;
	}
	
	/**
	 * get javadoc location of the package
	 * @return
	 * @throws ServiceNotAvaiableFault
	 */
	public String getDocLocation() throws ServiceNotAvaiableFault {
		logger.debug("GCubePackage, getDocLocation method");
		String url=null;
		initialize();
		try{
	// retrieve or convert in maven Coordinates		
			MavenCoordinates mavenC = getMavenCoordinates();
//			List<MavenCoordinates> mcList=new ArrayList<MavenCoordinates>();
//			mcList.add(mavenC);
	// Call to RepositoryManager with maven coordinates
			RepositoryManagerFactory rmf= new RepositoryManagerFactory();		
			rm= rmf.getRepositoryManager(is.getMavenServerList(scope), true);
			url=(String)rm.get(mavenC, "jar", "javadoc");			
			logger.debug(" url of javadoc founded: "+url);
		}catch(Exception e){
			throw new ServiceNotAvaiableFault(e.getMessage());
		}finally{
			if(url==null)
				throw new ServiceNotAvaiableFault("url is null ");
		}
		return url;
	}
	

/**
 * Retrieve location of softwareArchive identifies by coordinates	
 */
	@Override
	public String getSALocation() throws ServiceNotAvaiableFault {
		String url=null;
		initialize();
		File sa=null;
		logger.debug("Create a temporary directory: "+ coordinates.getServiceClass()+" in directory: "+ServiceContext.getContext().getTmp());
		File tmpParentDirectory = new File(ServiceContext.getContext().getTmp(), coordinates.getServiceClass());
		if(!tmpParentDirectory.exists())
			tmpParentDirectory.mkdir();
		File tmpTargetDirectory= new File(tmpParentDirectory, coordinates.getServiceName()+"_"+coordinates.getServiceVersion());
		try{
			MavenCoordinates mavenC = getSAMavenCoordinates();
			List<MavenCoordinates> mcList=new ArrayList<MavenCoordinates>();
			mcList.add(mavenC);
	// Call to RepositoryManager with maven coordinates to retrieve the url
			RepositoryManagerFactory rmf= new RepositoryManagerFactory();		
			rm= rmf.getRepositoryManager(is.getMavenServerList(scope), true);
			url = rm.getSALocation(tmpTargetDirectory, mcList, coordinates);
		}catch(Exception e){
			throw new ServiceNotAvaiableFault(e.getMessage());
		}finally{
			if(url==null)
				throw new ServiceNotAvaiableFault("url is null ");
		}
		return url;
	}

	
	

	/**True if the profile contains only the package corresponded to the mc input parameter
	 * 
	 * @param mc maven coordinates
	 * @return
	 * @throws ServiceNotAvaiableFault
	 */
	private boolean verifyPackageNumber(MavenCoordinates mc) throws ServiceNotAvaiableFault {
		boolean onePackage=false;
		logger.debug("verifyPAckageNumber method with MavenCoordinates: "+mc.getGroupId()+" "+mc.getArtifactId()+" "+mc.getVersion());
		List<GCubePackage> listCoord=getPackages();
		if(listCoord==null)
			throw new ServiceNotAvaiableFault();
		else if(listCoord.size() == 1){
			GCubePackage mCoord=listCoord.get(0);
			if((mc.getArtifactId().equals(mCoord.getCoordinates().getArtifactId()) && (mc.getGroupId().equals(mCoord.getCoordinates().getGroupId())))){
				onePackage=true;
			}
		}
		return onePackage;
	}
	
	/**
	 * Return an XML document that contains resolved and missing dependencies
	 * ex:
	 * 
	 * 
	 */
	@Override
	public String getDependencies() throws ServiceNotAvaiableFault {
		logger.debug("GCubePackage, getDependencies method");
		initialize();
		String result=null;
		try{
			result=findDeps();
		}catch(Exception e){
			throw new ServiceNotAvaiableFault();
		}finally{
			if(result == null)
				throw new ServiceNotAvaiableFault();

		}
		return result;
	}

	/**
	 * This method retrieves all packages that matches with the coordinates
	 */
	@Override
	public List<GCubePackage> getPackages() throws ServiceNotAvaiableFault {
		initialize();
		List<GCubePackage> coordList=null;
		URL url=null;
		try{
			coordList=is.getGCubePackagesCoordinates(coordinates);
		}catch(ISException e){
			throw new ServiceNotAvaiableFault("Coordinates not found");
		}finally{
			if(coordList == null)
				throw new ServiceNotAvaiableFault("Coordinates not found");
		}
		return coordList;
	}

	/**
	 * this method retrieves all plugin coordinates matches with the coordinates 
	 */
	@Override
	public List<GCubePackage> getPlugins() throws ServiceNotAvaiableFault {
		logger.debug(" getPlugins method ");
		initialize();
		List<GCubePackage> coordList=null;
		URL url=null;
		try{
			coordList=is.getPluginCoordinates(coordinates);
		}catch(ISException e){
			throw new ServiceNotAvaiableFault();
		}
		return coordList;
	}

	/**
	 * Register a profile in IS.
	 * This method isn't implemented for this class.
	 * The real implementation is in the Register class
	 *	 
	 */
	@Override
	public String register() {
		// TODO Auto-generated method stub
		return null;
	}
	/**
	 * Unregister a profile in IS.
	 * This method isn't implemented for this class.
	 * The real implementation is in the Register class
	 *	 
	 */
	@Override
	public void unregister() throws ServiceNotAvaiableFault {
		initialize();
		logger.debug("GCubePackage unregister method");
		List<MavenPackage> coordList=null;
		URL url=null;
		List<GCubePackage> list=null;
	// get list of gcubePackage	
		try {
			list= is.updatePackageResource(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion());
		} catch (ISException e) {
			// TODO Auto-generated catch block
			throw new ServiceNotAvaiableFault();
		}
	}
	/**
	 * Return the current coordinates
	 * 
	 */
	public Coordinates getCoordinates() {
		return coordinates;
	}
	/**
	 * Set the coordinates
	 * @param coordinates
	 * @throws BadCoordinatesException
	 */
	private void setCoordinates(Coordinates coordinates) throws BadCoordinatesException {
		logger.debug("GCubePackage setCoordinates");
		this.coordinates = coordinates;//new GCubeCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion());
		logger.debug("GCubePackage Coordinates ok");
	}

	/**
	 * query to IS maven coordinates, if not found, try to convert in gCube coordinate follow specific description
	 * @param gcubeC
	 * @return
	 * @throws BadCoordinatesException
	 */
	private MavenCoordinates getMavenCoordinates()
			throws BadCoordinatesException {
   // try to get coordinates from IS
		MavenCoordinates mavenC=null;
		logger.debug("getMavenCoordinates method: with maven Coordinates: g "+coordinates.getGroupId()+" a "+coordinates.getArtifactId()+" v "+coordinates.getVersion());
		if((coordinates.getGroupId()== null) ||(coordinates.getArtifactId()==null) || (coordinates.getVersion()==null)){
			try{	
				mavenC = is.getMavenCoordinates(coordinates);
			}catch(ISException e){
				logger.error("IS EXCEPTION CATCHED");
			}
	   //if the is return is null, then converts coordinates from gCubeCoordinates to MavenCoordinates		
			if(mavenC==null){
				logger.debug(" no maven coordinates founded in profile. Try to convert from gCube to Maven");
				try{
					mavenC = (MavenCoordinates)coordinates.convert();
				}catch(BadCoordinatesException e){
					throw new BadCoordinatesException(" convert from gcube to maven");
				}
			}else{
				logger.debug("founded maven Coordinates in profile: gid: "+mavenC.getGroupId()+" aid: "+mavenC.getArtifactId()+" v: "+mavenC.getVersion());
			}
		}else{
			logger.debug("maven coordinates already setted ");
			mavenC=new MavenCoordinates(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
		}
		return mavenC;
	}

	
	/**
	 * query to IS the SA maven coordinates, if not found, try to convert in gCube coordinate follow specific description
	 * @param gcubeC
	 * @return
	 * @throws BadCoordinatesException
	 */
	private MavenCoordinates getSAMavenCoordinates()
			throws BadCoordinatesException {
   // try to get coordinates from IS
		MavenCoordinates mavenC=null;
		logger.debug("getMavenCoordinates method: with maven Coordinates: g "+coordinates.getGroupId()+" a "+coordinates.getArtifactId()+" v "+coordinates.getVersion());
		if((coordinates.getGroupId()== null) ||(coordinates.getArtifactId()==null) || (coordinates.getVersion()==null)){
			try{	
				mavenC = is.getSAMavenCoordinates(coordinates);
			}catch(ISException e){
				logger.error("IS EXCEPTION CATCHED");
			}
	   //if the is return is null, then converts coordinates from gCubeCoordinates to MavenCoordinates		
			if(mavenC==null){
				logger.debug(" no maven coordinates founded in profile. Try to convert from gCube to Maven");
				try{
					mavenC = (MavenCoordinates)coordinates.convert();
				}catch(BadCoordinatesException e){
					throw new BadCoordinatesException(" convert from gcube to maven");
				}
			}else{
				logger.debug("founded maven Coordinates in profile: gid: "+mavenC.getGroupId()+" aid: "+mavenC.getArtifactId()+" v: "+mavenC.getVersion());
			}
		}else{
			logger.debug("maven coordinates already setted ");
			mavenC=new MavenCoordinates(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
		}
		return mavenC;
	}

	
	/**
	 * Extract dependencies from maven repositories
	 * @param serviceName
	 * @param serviceClass
	 * @param serviceVersion
	 * @param packageName
	 * @param packageVersion
	 * @throws Exception 
	 * @throws BadCoordinatesException
	 */
	private String findDeps()
			throws ServiceNotAvaiableFault {
		logger.debug("findDeps method");
		List<Package> list=null;
		String url=null;
		List<MavenCoordinates> mavenList = convertGcubeToMaven();
		logger.info("founded "+mavenList.size()+" packages ");
// Call to RepositoryManager with maven coordinates
		logger.debug("try to retrieve Repository Manager server list");
		RepositoryManagerFactory rmf= new RepositoryManagerFactory();
		try{
			rm= rmf.getRepositoryManager(is.getMavenServerList(scope), true);
		}catch(Exception e){
			throw new ServiceNotAvaiableFault(e.getMessage());
		}
		String result=null;
		String resultMerged=null;
		ArrayList<String> resultList=new ArrayList<String>();
		for(MavenCoordinates mavenC: mavenList){
			try{
				logger.debug(" try to retrieve pom's url for coordinates gid= "+mavenC.getGroupId()+" aid: "+mavenC.getArtifactId()+" v: "+mavenC.getVersion());
				url=rm.get(mavenC, "pom", null);
				logger.debug(" pom url is : "+url);
			}catch(Exception e){
//				throw new ServiceNotAvaiableFault(e.getMessage());
				logger.info("url is null for package "+mavenC.getGroupId()+" "+mavenC.getArtifactId()+" "+mavenC.getVersion());
				break;
			}//finally{		
//				if(url == null)
//					throw new ServiceNotAvaiableFault();
			//}
			logger.debug("pom file founded, try to extract Dependencies...");
			result=rm.extractDepsFromMavenEmb(url.toString());
			resultList.add(result);
		}
		resultMerged=mergeResult(resultList);
		return resultMerged.toString();
	}

	
	private String mergeResult(ArrayList<String> resultList) {
		logger.debug("mergeResult method");
		StringBuffer resolvedDep=new StringBuffer();
		StringBuffer missingDep=new StringBuffer();
		String merged="";
		for(String result : resultList){
			try{
				logger.debug("process: \n"+result);
				if((result.contains("<ResolvedDependencies>")) && (result.contains("</ResolvedDependencies>"))){
					String temp=result.substring(result.lastIndexOf("<ResolvedDependencies>"), result.lastIndexOf("</ResolvedDependencies>"));
					temp=temp.substring(22);
					logger.debug("resolved deps:\n"+temp);
					resolvedDep.append(temp);
				}
				if((result.contains("<MissingDependencies>")) && (result.contains("</MissingDependencies>"))){
					String temp2=result.substring(result.lastIndexOf("<MissingDependencies>"), result.lastIndexOf("</MissingDependencies>"));
					temp2=temp2.substring(21);
					logger.debug("missing deps:\n"+temp2);
					missingDep.append(temp2);
				}
			}catch(Exception e){
				logger.error("exception: "+e.getMessage());
				e.printStackTrace();
			}
		}
		String result="<DependencyResolutionReport>\n\t<ResolvedDependencies>\n"+resolvedDep.toString()+"</ResolvedDependencies>\n"+"<MissingDependencies>\n"+missingDep.toString()+"</MissingDependencies>\n</DependencyResolutionReport>";
//		result=result.replaceAll("<Dependency>", "\t<Dependency>\n");
//		result=result.replaceAll("</Dependency>", "\t</Dependency>\n");
//		result=result.replaceAll("<MissingDependency>", "\t<MissingDependency>\n");
//		result=result.replaceAll("</MissingDependency>", "\t</MissingDependency>\n");
//		result=result.replaceAll("<Service>", "\t<Service>\n");
//		result=result.replaceAll("</Service>", "\n\t\t</Service>\n");
//		result=result.replaceAll("<Class>", "\t\t<Class>");
//		result=result.replaceAll("</Class>", "</Class>\n");
//		result=result.replaceAll("<Name>", "\t\t<Name>");
//		result=result.replaceAll("</Name>", "</Name>\n");
//		result=result.replaceAll("<Version>", "\t\t<Version>");
//		result=result.replaceAll("</Version>", "</Version>");
//		result=result.replaceAll("<Package>", "\t<Package>");
//		result=result.replaceAll("</Package>", "</Package>\n");
		return result;
	}

	/**
	 * Converts GCube coordinate to maven coordinates
	 * @return
	 * @throws BadCoordinatesException
	 */
	private List<MavenCoordinates> convertGcubeToMaven() throws BadCoordinatesException{
		GCubeCoordinates gcubeC=null;
		logger.debug("convertGcubeToMaven method");
		// retrieve maven coordinates
		List<MavenCoordinates> mavenList=new ArrayList<MavenCoordinates>();
		if((coordinates.getPackageName() == null) && (coordinates.getPackageVersion()==null)){
			// then we want the packages coordinates
			logger.debug("Package coordinates are null. Try to extract all package coordinates");
			List<org.gcube.common.core.resources.service.Package> packs=null;
			try {
				packs = is.queryPackagesCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion());
			} catch (ISException e) {
				e.printStackTrace();
			}
			for(org.gcube.common.core.resources.service.Package p : packs) {
//				logger.debug("MainPackage search: item "+p.getName()+" "+p.getVersion());
//				 if (org.gcube.common.core.resources.service.MainPackage.class.isAssignableFrom(p.getClass())){
//					 coordinates.setPackageName(p.getName());
//					 coordinates.setPackageVersion(p.getVersion());
//					 logger.debug("MainPackage search: founded "+p.getName()+" "+p.getVersion());
//					 break;
//				 }
				
				
				
				
				logger.debug("processing pack: "+p.getName()+" "+p.getVersion());
				try{
					String gId=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.groupId);
					String aId=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.artifactId);
					String v=p.getMavenCoordinate(org.gcube.common.core.resources.service.Package.MavenCoordinate.version);
					MavenCoordinates mc=new MavenCoordinates(gId, aId, v);
					logger.debug("package added: "+gId+" "+aId+" "+v);
					mavenList.add(mc);
				}catch(BadCoordinatesException e){
					logger.warn("package  not added, bad coordinate founded ");
				}
			}
//			if(coordinates.getPackageName()!=null){
//				MavenCoordinates mavenC = getMavenCoordinates();
//				logger.info("Maven Coordinates founded are: gid: "+mavenC.getGroupId()+" aid "+mavenC.getArtifactId()+" v "+mavenC.getVersion());
//				mavenList.add(mavenC);
//			}else{
//				logger.debug("MainPackage not  founded ");
//			}
		}else{
			//else we want the artifact coordinates
			MavenCoordinates mavenC = getMavenCoordinates();
			logger.info("Maven Coordinates founded are: gid: "+mavenC.getGroupId()+" aid "+mavenC.getArtifactId()+" v "+mavenC.getVersion());
			mavenList.add(mavenC);
		}
		return mavenList;
	}
		
}
