/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.contexts;

import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcebroker.impl.contexts.StatefulBrokerContext;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.services.BrokerService;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.console.PrettyFormatter;
import org.globus.wsrf.ResourceException;

class ResourceBinderTask
extends GCUBEHandler<Object> {
    private GCUBELog logger = new GCUBELog((Object)this, PrettyFormatter.bold(BrokerConfiguration.getProperty("LOGGING_PREFIX") + "::[RES-BINDER]"));

    ResourceBinderTask() {
    }

    private void publishResource(GCUBEScope scope) throws ResourceException {
        Assertion<ResourceException> checker = new Assertion<ResourceException>();
        checker.validate(scope != null, new ResourceException("The given parameter is null."));
        ServiceContext.getContext().setScope(scope);
        StatefulBrokerContext.getContext().getWSHome().create(StatefulBrokerContext.getResPlanKey(), new Object[0]);
        this.logger.debug((Object)("[PUBLISH] Binding Stateful Resource BOUND to scope [" + scope + "]"));
    }

    public void run() throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(ServiceContext.getContext() != null, new GCUBEFault(new String[]{"Context not defined"}));
        checker.validate(ServiceContext.getContext().getInstance() != null, new GCUBEFault(new String[]{"Context instance not defined"}));
        checker.validate(ServiceContext.getContext().getInstance().getScopes() != null, new GCUBEFault(new String[]{"Context instance scopes not defined"}));
        checker.validate(ServiceContext.getContext().getInstance().getScopes().values().size() > 0, new GCUBEFault(new String[]{"Context instance scopes not defined"}));
        this.logger.info((Object)("[BINDING-LOOP] Available scopes: " + ServiceContext.getContext().getInstance().getScopes().values()));
        if (ServiceContext.getContext().getInstance().getScopes().values().size() != 1) {
            this.logger.error((Object)PrettyFormatter.underlined(BrokerService.class.getSimpleName() + " has been configured to join more than one scope, while it can work only in ONE single scope. Configure the deploy-jndi-config.xml file of broker properly."));
            if (BrokerConfiguration.getProperty("CONTEXT_SCOPE") != null) {
                this.logger.warn((Object)"Trying with default configuration in broker.properties.");
                try {
                    this.publishResource(GCUBEScope.getScope((String)BrokerConfiguration.getProperty("CONTEXT_SCOPE")));
                }
                catch (Exception e) {
                    throw new GCUBEFault((Throwable)e, new String[]{BrokerService.class.getSimpleName() + " failed with default scope binding"});
                }
            } else {
                throw new GCUBEFault(new String[]{BrokerService.class.getSimpleName() + " has been configured to join more than one scope, while it can work only in ONE single scope"});
            }
            return;
        }
        boolean done = false;
        Iterator scopes = ServiceContext.getContext().getInstance().getScopes().values().iterator();
        GCUBEScope scope = (GCUBEScope)scopes.next();
        while (!done && scope != null) {
            try {
                this.publishResource(scope);
                done = true;
                ResourceStorageManager.INSTANCE.getResource();
            }
            catch (ResourceException e) {
                this.logger.error((Object)("Cannot bind the resource to the proposed scope " + scope.toString()));
                this.logger.error((Object)e);
                scope = (GCUBEScope)scopes.next();
            }
        }
    }
}

