/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.threads;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.services.ISClientRequester;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TimedThread;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;

public class TUpdateGHNProfiles
extends TimedThread {
    private GCUBEScope scope = null;

    public TUpdateGHNProfiles(long delay, GCUBEScope scope) {
        super(delay, false);
        this.scope = scope;
        this.logger.debug((Object)("[TTHREADS] Starting " + this.getClass().getSimpleName() + " delay: " + delay));
    }

    @Override
    public final void loop() {
        try {
            List<GHNDescriptor> currentGHNs = GHNReservationHandler.getInstance().getGlobalGHNsForScope(this.scope, false);
            List<GHNDescriptor> newGHNs = ISClientRequester.getRIOnGHNs(this.scope);
            if (currentGHNs == null || newGHNs == null) {
                return;
            }
            GHNDescriptor ghnToUpdate = null;
            for (GHNDescriptor ghn : newGHNs) {
                ghnToUpdate = GHNReservationHandler.getInstance().getGHNByID(null, this.scope, ghn.getID());
                if (ghnToUpdate == null) {
                    GHNReservationHandler.getInstance().addGHNDescriptor(ghn);
                    continue;
                }
                ghnToUpdate.setRICount(ghn.getRICount());
            }
            List<GHNDescriptor> oldGHNs = GHNReservationHandler.getInstance().getGlobalGHNsForScope(this.scope, false);
            Vector<GHNDescriptor> ghnsToRemove = new Vector<GHNDescriptor>();
            for (GHNDescriptor ghn : oldGHNs) {
                if (newGHNs.contains(ghn) || ghn.isReserved()) continue;
                this.logger.debug((Object)("*** [DELETE] ghn " + ghn.getID()));
                ghnsToRemove.add(ghn);
            }
            for (GHNDescriptor ghnToRemove : ghnsToRemove) {
                oldGHNs.remove(ghnToRemove);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

