/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.types;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Tuple<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 5783359179069297888L;
    private List<T> content = new LinkedList<T>();

    public final List<T> getContent() {
        return this.content;
    }

    public final void setContent(List<T> content) {
        this.content = content;
    }

    public Tuple() {
    }

    public Tuple(T ... args) {
        for (T t : args) {
            this.content.add(t);
        }
    }

    public final void append(T ... args) {
        if (this.content != null) {
            for (T t : args) {
                this.content.add(t);
            }
        }
    }

    public final Tuple<? extends T> union(Tuple<? extends T> t) {
        Tuple<Object> retval = new Tuple<Object>();
        for (T elem : this.content) {
            retval.append(elem);
        }
        for (int i = 0; i < t.size(); ++i) {
            retval.append(t.get(i));
        }
        return retval;
    }

    public final T get(int index) {
        return this.content.get(index);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.content.iterator();
    }

    public final int size() {
        return this.content.size();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple tuple = (Tuple)obj;
        if (tuple.size() != this.content.size()) {
            return false;
        }
        Iterator<T> internalElems = this.content.iterator();
        for (T elem : tuple) {
            if (elem.equals(internalElems.next())) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int retval = 0;
        Iterator<T> internalElems = this.content.iterator();
        while (internalElems.hasNext()) {
            retval += internalElems.next().hashCode();
        }
        return retval;
    }

    public final String toString() {
        StringBuilder retval = new StringBuilder();
        for (T o : this.content) {
            retval.append(o.toString() + "/");
        }
        return "(" + retval.substring(0, retval.length() - 1) + ")";
    }
}

