/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanExceptionMessages;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;

public class HandleRequirementsTask
extends PlanBuilderTask {
    @Override
    public final PlanBuilderElem makeDecision(PlanBuilderElem input) throws PlanBuilderException {
        Assertion<PlanBuilderException> checker = new Assertion<PlanBuilderException>();
        checker.validate(input != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest().getScope() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST_SCOPE));
        if (input.getRequest() == null || input.getRequest().getPackageGroups() == null || input.getRequest().getPackageGroups().size() == 0) {
            this.logger.info((Object)"[PLAN-REQS] no elems to handle");
            return input;
        }
        Vector<PackageGroup> pgToRemove = new Vector<PackageGroup>();
        for (PackageGroup group : input.getRequest().getPackageGroups()) {
            if (!group.hasRequirements()) continue;
            this.logger.info((Object)("[PLAN-REQS] found PG: " + group.getID() + " having requirements"));
            pgToRemove.add(group);
            List reqs = group.getRequirements();
            GHNDescriptor ghn = null;
            try {
                GCUBEScope scopeToUse = null;
                scopeToUse = GCUBEScope.getScope((String)input.getRequest().getScope()).getType() == GCUBEScope.Type.VRE ? GCUBEScope.getScope((String)input.getRequest().getScope()).getEnclosingScope() : GCUBEScope.getScope((String)input.getRequest().getScope());
                ghn = GHNReservationHandler.getInstance().getNextMatchingGHN(scopeToUse, input.getID(), reqs.toArray(new Requirement[0]), true);
            }
            catch (Exception e) {
                this.logger.error((Object)this, (Throwable)e);
            }
            if (ghn != null) {
                PackageGroup pckGrpToInsert = input.getResponse().createPackageGroup(group.getServiceName());
                pckGrpToInsert.setGHN(ghn.getID());
                this.logger.debug((Object)("[PLAN-REQS] reassigning package " + group.getID()));
                pckGrpToInsert.setID(group.getID());
                if (group.getPackages() == null) {
                    this.logger.error((Object)("[PLAN-REQS-ERR] the packageGroup has no children Package " + group.getID()));
                }
                for (PackageElem p : group.getPackages()) {
                    pckGrpToInsert.addPackage(new PackageElem(p));
                }
                continue;
            }
            throw new PlanBuilderException(PlanExceptionMessages.REQUIREMENTS_NOT_SATISFIED, group);
        }
        for (PackageGroup group : pgToRemove) {
            input.getRequest().getPackageGroups().remove(group);
        }
        return input;
    }
}

