/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.FeedbackStatus;

public class DeployNode {
    public static final String NODE_TAG = "DeployNode";
    @XStreamAlias(value="PackageGroup")
    private PackageGroup packageGroup = null;

    public DeployNode(PackageGroup pg) {
        this.setPackageGroup(pg);
    }

    private int evaluateScore() {
        if (this.getPackageGroup() == null || this.getPackageGroup().getPackages() == null) {
            return 0;
        }
        float total = this.getPackageGroup().getPackages().size();
        float partialScore = 0.0f;
        for (PackageElem p : this.getPackageGroup().getPackages()) {
            if (p.getStatus() != null) {
                partialScore += p.getStatus().getWeight();
                continue;
            }
            partialScore += FeedbackStatus.SUCCESS.getWeight();
        }
        float percentage = 100.0f / total * partialScore;
        return Math.round(percentage);
    }

    public final int getScore() {
        return this.evaluateScore();
    }

    public final void setPackageGroup(PackageGroup pg) {
        this.packageGroup = pg;
    }

    public final PackageGroup getPackageGroup() {
        return this.packageGroup;
    }
}

