/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collections;
import java.util.List;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.Software;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;

public final class ScopedAnyResource
extends ScopedResource {
    @XStreamOmitField
    Resource profile = null;
    @XStreamOmitField
    Class profileClass = null;

    protected ScopedAnyResource(String id, String type, GCUBEScope scope) {
        super(id, type, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void find() throws Exception {
        block12: {
            Class<GenericResource> queryType = null;
            if (this.type.compareToIgnoreCase("GenericResource") == 0) {
                queryType = GenericResource.class;
                this.profileClass = GCUBEGenericResource.class;
            } else if (this.type.compareToIgnoreCase("Service") == 0) {
                queryType = Software.class;
                this.profileClass = GCUBEService.class;
            } else if (this.type.compareToIgnoreCase("RuntimeResource") == 0) {
                queryType = ServiceEndpoint.class;
                this.profileClass = GCUBERuntimeResource.class;
            } else {
                throw new Exception("Unknown resource type: " + this.type);
            }
            List profiles = null;
            try {
                XQuery query = ICFactory.queryFor(queryType);
                query.addCondition(String.format("$resource/ID/string() eq '%s'", this.id));
                this.logger.info((Object)("execution query " + query + " on scope " + this.scope + " with id: " + this.id));
                DiscoveryClient client = ICFactory.clientFor(queryType);
                ScopeProvider.instance.set(this.getScope().toString());
                profiles = client.submit((Query)query);
                if (profiles != null && profiles.size() > 0) {
                    this.logger.info((Object)"profile found ");
                    this.profile = (Resource)profiles.get(0);
                    break block12;
                }
                String enclosingScope = GCUBEScope.getScope((String)this.scope).getEnclosingScope().toString();
                try {
                    ScopeProvider.instance.set(GCUBEScope.getScope((String)this.scope).getEnclosingScope().toString());
                    this.logger.info((Object)("profile not found. Try on enclosing scope: " + enclosingScope));
                    this.profile = (Resource)client.submit((Query)query).get(0);
                }
                finally {
                    ScopeProvider.instance.set(this.scope.toString());
                }
            }
            catch (Throwable e) {
                this.getLogger().error((Object)("bad query. Caused by: " + e.getCause()));
                throw new Exception("unable to find the target resource (ID=" + this.id + "). Possible cause: " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected void addToScope() throws ScopedResource.ResourceNotFound, Exception {
        this.findResource();
        this.getLogger().debug((Object)"Adding scope to resource profile");
        try {
            this.getLogger().debug((Object)("republish the resource " + this.profile.id() + " with scope added " + this.getScope()));
            ScopedPublisher publisher = RegistryPublisherFactory.scopedPublisher();
            publisher.create(this.profile, Collections.singletonList(this.getScope().toString()));
        }
        catch (Exception e) {
            this.noHopeForMe("Failed to add the scope (" + this.getScope() + ") to resource " + this.getId(), e);
        }
    }

    @Override
    protected void removeFromScope() throws ScopedResource.ResourceNotFound, Exception {
        this.findResource();
        this.getLogger().debug((Object)"Removing scope from resource profile");
        try {
            ScopedPublisher publisher = RegistryPublisherFactory.scopedPublisher();
            publisher.remove(this.profile, Collections.singletonList(this.getScope().toString()));
        }
        catch (Exception e) {
            this.noHopeForMe("Failed to remove the scope (" + this.getScope() + ") from resource " + this.getId(), e);
        }
    }
}

