/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.porttypes;

import java.util.HashSet;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.reporting.DeployerReport;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.porttypes.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.NoSuchReportFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.SendReportParameters;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;

public class Reporting
extends ResourceManagerPortType {
    public void sendReport(SendReportParameters reportMessage) throws GCUBEFault {
        GCUBEScope targetScope = GCUBEScope.getScope((String)reportMessage.getTargetScope());
        this.logger.info((Object)("Received session for session " + reportMessage.getCallbackID()));
        this.logger.trace((Object)("Report content: \n" + reportMessage.getReport()));
        try {
            Session session = this.getInstanceState().getSession(reportMessage.getCallbackID());
            DeployerReport dreport = new DeployerReport(this.getInstanceState(), targetScope, reportMessage.getReport());
            session.addGHNReport(dreport);
            session.save();
            PublishedScopeResource resource = this.getInstanceState().getPublishedScopeResource(targetScope);
            this.logger.debug((Object)("Status session is: " + dreport.getStatus()));
            if (dreport.getStatus().compareToIgnoreCase("CLOSED") == 0) {
                this.logger.trace((Object)("Setting the gHN " + dreport.getGHNName() + " as non working"));
                this.getInstanceState().getState(targetScope).getNode(dreport.getGHNName()).isNotWorking();
                this.logger.trace((Object)"Parsing running instances (if any)...");
                HashSet<ScopedResource> resources = new HashSet<ScopedResource>();
                for (DeployerReport.DeployedRunningInstance instance : dreport.getInstances()) {
                    if (instance.isAlive()) {
                        this.logger.trace((Object)("Adding instance " + instance.getRIID() + " to PublishedScopeResource"));
                        resource.addResource(instance.getInstance());
                        resources.add(instance.getInstance());
                        continue;
                    }
                    this.logger.warn((Object)("Instance " + instance.getRIID() + " not found on the IS"));
                }
                session.addDeployedInstances(dreport.getInstances());
                this.getInstanceState().getState(targetScope).addResources(resources);
            }
            resource.publish();
            session.save();
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"Unable to find ResourceManager resource", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to find ResourceManager resource", e).toFault(new String[0]);
        }
        catch (ResourceException e) {
            this.logger.error((Object)"Unable to find ResourceManager resource", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to find ResourceManager resource", e).toFault(new String[0]);
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Unable to parse or save the Deployer Report", e).toFault(new String[0]);
        }
    }

    public String getReport(String ID) throws NoSuchReportFaultType {
        try {
            return this.getInstanceState().getSession(ID).toXML();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to retrieve the Resource Report for ID " + ID), (Throwable)e);
            throw new NoSuchReportFaultType();
        }
    }
}

