/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.resources.software;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.GCUBEPackage;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.DependenciesCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;
import org.kxml2.io.KXmlParser;

public final class SoftwareGatewayRequest {
    static Map<GCUBEScope, Set<EndpointReferenceType>> scopeMap = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private Map<ScopedDeployedSoftware, DependenciesCoordinates> requests = new HashMap<ScopedDeployedSoftware, DependenciesCoordinates>();
    protected static final String RESOLVED_DEPS_KEY = "listResolvedDeps";
    protected static final String MISSING_DEPS_KEY = "listMissingDeps";
    protected static final String REPOSITORY_ENDPOINT = "gcube/vremanagement/softwaregateway/Access";
    protected static final String REPOSITORY_NAME = "SoftwareGateway";
    protected static final String REPOSITORY_CLASS = "VREManagement";
    protected static final int TIMEOUT = 600000;
    protected final GCUBELog logger = new GCUBELog((Object)this);

    public void addSoftware(ScopedDeployedSoftware service) {
        if (service == null || service.getSourcePackage() == null) {
            throw new IllegalArgumentException("Software cannot be null");
        }
        DependenciesCoordinates message = new DependenciesCoordinates();
        message.setServiceClass(service.getSourcePackage().getClazz());
        message.setServiceName(service.getSourcePackage().getName());
        message.setServiceVersion(service.getSourcePackage().getVersion());
        if (service.getSourcePackage().getPackageName() != null && service.getSourcePackage().getPackageName().length() > 0) {
            message.setPackageName(service.getSourcePackage().getPackageName());
        }
        if (service.getSourcePackage().getPackageVersion() != null && service.getSourcePackage().getPackageVersion().length() > 0) {
            message.setPackageVersion(service.getSourcePackage().getPackageVersion());
        }
        this.requests.put(service, message);
    }

    public List<ScopedDeployedSoftware> send(GCUBEScope scope) throws Exception {
        ArrayList<ScopedDeployedSoftware> service2package = new ArrayList<ScopedDeployedSoftware>();
        Map<GCUBEScope, Set<EndpointReferenceType>> eprs = this.findInstances();
        boolean found = false;
        for (ScopedDeployedSoftware service : this.requests.keySet()) {
            DependenciesCoordinates packageCoordinates = this.requests.get(service);
            this.logger.trace((Object)("Checking deps for " + packageCoordinates.getServiceName()));
            for (EndpointReferenceType epr : eprs.get(scope)) {
                try {
                    this.logger.trace((Object)("Trying Service Gateway located at " + epr));
                    AccessServiceAddressingLocator locator = new AccessServiceAddressingLocator();
                    AccessPortType pt = locator.getAccessPortTypePort(epr);
                    String report = ((AccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)(scope.getType() == GCUBEScope.Type.VRE ? scope.getEnclosingScope() : scope), (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()})).getDependencies(packageCoordinates);
                    service2package.add(this.parseDependenciesReport(service, report));
                    found = true;
                    break;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to check deps for " + packageCoordinates.getServiceName() + " at Service Gateway located at  " + epr.getAddress().toString()), (Throwable)e);
                }
            }
            if (found) continue;
            this.logger.error((Object)("Unable to check deps for " + packageCoordinates.getServiceName() + " from Service Gateway in " + scope));
            service.setErrorMessage("Unable to check deps for this service in any of the Service Gateway instances in scope");
            service2package.add(service);
            throw new Exception("Unable to check deps for this service in any of the Service Gateway instances in scope");
        }
        return service2package;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScopedDeployedSoftware parseDependenciesReport(ScopedDeployedSoftware service, String report) throws Exception {
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)new BufferedReader(new StringReader(report)));
        this.logger.trace((Object)("Parsing: " + report));
        try {
            block6: while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("ResolvedDependencies")) {
                            this.parseResolvedDependencies(parser, service);
                        }
                        if (!parser.getName().equals("MissingDependencies")) continue block6;
                        this.parseMissingDependencies(parser, service);
                        continue block6;
                    }
                    case 1: {
                        return service;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to parse the deployment report returned by the Software Repository", (Throwable)e);
        }
        return service;
    }

    private void parseService(KXmlParser parser, GCUBEPackage s) throws Exception {
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Class")) {
                        s.setClazz(parser.nextText());
                    }
                    if (parser.getName().equals("Name")) {
                        s.setName(parser.nextText());
                    }
                    if (!parser.getName().equals("Version")) continue block5;
                    s.setVersion(parser.nextText());
                    continue block5;
                }
                case 3: {
                    if (!parser.getName().equals("Service")) continue block5;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at Service");
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
    }

    private Dependency parseDependency(KXmlParser parser) throws Exception {
        Dependency p = new Dependency();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Service")) {
                        this.parseService(parser, p.getService());
                    }
                    if (parser.getName().equals("Package")) {
                        p.setName(parser.nextText());
                    }
                    if (!parser.getName().equals("Version")) continue block5;
                    p.setVersion(parser.nextText());
                    continue block5;
                }
                case 3: {
                    if (!parser.getName().equals("Dependency") && !parser.getName().equals("MissingDependency")) continue block5;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at Dependency");
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return p;
    }

    private void parseResolvedDependencies(KXmlParser parser, ScopedDeployedSoftware service) throws Exception {
        this.logger.trace((Object)"Parsing resolved dependencies...");
        ArrayList<Dependency> resolved = new ArrayList<Dependency>();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("Dependency")) continue block5;
                    this.logger.trace((Object)"Dependency found");
                    resolved.add(this.parseDependency(parser));
                    continue block5;
                }
                case 3: {
                    if (!parser.getName().equals("ResolvedDependencies")) continue block5;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at ResolvedDependencies");
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        this.logger.trace((Object)("Number of deps found: " + resolved.size()));
        service.setResolvedDependencies(resolved);
    }

    private void parseMissingDependencies(KXmlParser parser, ScopedDeployedSoftware service) throws Exception {
        this.logger.trace((Object)"Parsing missing dependencies...");
        ArrayList<Dependency> missing = new ArrayList<Dependency>();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("MissingDependency")) continue block5;
                    this.logger.trace((Object)"Dependency found");
                    missing.add(this.parseDependency(parser));
                    continue block5;
                }
                case 3: {
                    if (!parser.getName().equals("MissingDependencies")) continue block5;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at MissingDependencies");
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        this.logger.trace((Object)("Number of deps found: " + missing.size()));
        service.setMissingDependencies(missing);
    }

    protected Map<GCUBEScope, Set<EndpointReferenceType>> findInstances() throws Exception {
        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
            this.logger.debug((Object)("Looking for SG instances in " + scope.toString()));
            if (scopeMap.containsKey(scope) && scopeMap.get(scope).size() != 0) continue;
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", REPOSITORY_NAME)});
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", REPOSITORY_CLASS)});
            this.logger.debug((Object)("Quering in scope " + scope));
            List list = client.execute((ISQuery)lookupQuery, scope);
            this.logger.debug((Object)("Found N." + list.size() + " instances"));
            for (GCUBERunningInstance instance : list) {
                this.logger.trace((Object)("Found instance " + instance.toString()));
                EndpointReferenceType epr = instance.getAccessPoint().getEndpoint(REPOSITORY_ENDPOINT);
                this.logger.trace((Object)("Found EPR " + epr.toString()));
                if (!scopeMap.keySet().contains(scope)) {
                    HashSet l = new HashSet();
                    scopeMap.put(scope, l);
                }
                scopeMap.get(scope).add(epr);
            }
        }
        return scopeMap;
    }
}

