/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.reporting;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.DeployedDependency;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.GCUBEPackage;
import org.gcube.vremanagement.resourcemanager.impl.state.InstanceState;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class DeployerReport {
    protected GCUBELog logger = new GCUBELog((Object)this);
    protected InstanceState instanceState;
    protected GCUBEScope targetScope;
    protected String report = "";
    private String status = "";
    private String name = "";
    private String host = "";
    private String type = "";
    private Date lastUpdate;
    private List<DeployedDependency> dependencies = new ArrayList<DeployedDependency>();
    private Set<DeployedRunningInstance> instances = new HashSet<DeployedRunningInstance>();

    public DeployerReport(InstanceState instanceState, GCUBEScope targetScope, String report) throws Exception {
        this.report = report;
        this.instanceState = instanceState;
        this.targetScope = targetScope;
        try {
            this.parse();
        }
        catch (XmlPullParserException e) {
            throw new Exception("invalid Deployer Report");
        }
    }

    public String getGHNName() {
        return this.name;
    }

    public String toString() {
        return this.report;
    }

    public String getType() {
        return this.type;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public List<DeployedDependency> getDependencies() {
        return this.dependencies;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() throws Exception {
        KXmlParser parser = new KXmlParser();
        parser.setInput((Reader)new BufferedReader(new StringReader(this.report)));
        try {
            block6: while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("GHN")) {
                            this.name = parser.nextText();
                            continue block6;
                        }
                        if (parser.getName().equals("Type")) {
                            this.type = parser.nextText();
                            continue block6;
                        }
                        if (parser.getName().equals("LastUpdate")) {
                            this.lastUpdate = ProfileDate.fromXMLDateAndTime(parser.nextText());
                            continue block6;
                        }
                        if (parser.getName().equals("Status")) {
                            this.status = parser.nextText();
                            continue block6;
                        }
                        if (parser.getName().equals("Packages")) {
                            this.parsePackages(parser);
                            continue block6;
                        }
                        if (!parser.getName().equals("NewInstances")) continue block6;
                        this.parseInstances(parser);
                        continue block6;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to parse the Deployer Report", (Throwable)e);
            throw new Exception("Unable to parse the Deployer Report", e);
        }
    }

    private void parseInstances(KXmlParser parser) throws Exception {
        block14: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("NewInstance")) continue block14;
                    DeployedRunningInstance instance = new DeployedRunningInstance();
                    block15: while (true) {
                        switch (parser.next()) {
                            case 2: {
                                if (parser.getName().equals("ID")) {
                                    instance.setRIId(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceClass")) {
                                    instance.setServiceClass(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceName")) {
                                    instance.setServiceName(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceVersion")) {
                                    instance.setServiceVersion(parser.nextText());
                                }
                                if (parser.getName().equals("PackageVersion")) {
                                    instance.setPackageVersion(parser.nextText());
                                }
                                if (!parser.getName().equals("PackageName")) continue block15;
                                instance.setPackageName(parser.nextText());
                                continue block15;
                            }
                            case 3: {
                                if (!parser.getName().equals("NewInstance")) continue block15;
                                try {
                                    try {
                                        ScopedRunningInstance ri = (ScopedRunningInstance)ScopedResourceFactory.newResource(this.targetScope, instance.getRIID(), "RunningInstance");
                                        ri.setHostedON(this.host);
                                        ri.setJointTime(Calendar.getInstance().getTime());
                                        ri.setStatus(ScopedResource.STATUS.PUBLISHED);
                                        instance.setInstance(ri);
                                        instance.isAlive = true;
                                        instance.setMessage("An instance of this service has been correctly activated on " + this.host);
                                    }
                                    catch (Exception e) {
                                        this.logger.error((Object)("An instance of this service has been activated but it didn't start correctly on " + this.host + ". The expected instance identifier was " + instance.getRIID()), (Throwable)e);
                                        instance.setMessage("An instance of this service has been activated but it didn't start correctly on " + this.host + ". The expected instance identifier was " + instance.getRIID());
                                        instance.isAlive = false;
                                        this.instances.add(instance);
                                        continue block14;
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.instances.add(instance);
                                    throw throwable;
                                }
                                this.instances.add(instance);
                                continue block14;
                            }
                            case 1: {
                                throw new Exception("Parsing failed at NewInstance");
                            }
                        }
                    }
                }
                case 3: {
                    if (!parser.getName().equals("NewInstances")) continue block14;
                    break block14;
                }
                case 1: {
                    throw new Exception("Parsing failed at NewInstances");
                }
                default: {
                    continue block14;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePackages(KXmlParser parser) throws Exception {
        try {
            block12: while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (!parser.getName().equals("Package")) continue block12;
                        DeployedDependency dd = new DeployedDependency();
                        dd.setService(new GCUBEPackage());
                        block13: while (true) {
                            switch (parser.next()) {
                                case 2: {
                                    if (parser.getName().equals("ServiceClass")) {
                                        dd.getService().setClazz(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("ServiceName")) {
                                        dd.getService().setName(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("ServiceVersion")) {
                                        dd.getService().setVersion(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("PackageName")) {
                                        dd.setName(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("PackageVersion")) {
                                        dd.setVersion(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("Status")) {
                                        dd.setStatus(parser.nextText());
                                        continue block13;
                                    }
                                    if (parser.getName().equals("Host")) {
                                        dd.setHost(parser.nextText());
                                        this.host = dd.getHost();
                                        continue block13;
                                    }
                                    if (parser.getName().equals("Message")) {
                                        dd.setMessage(parser.nextText());
                                        continue block13;
                                    }
                                    parser.nextText();
                                    continue block13;
                                }
                                case 3: {
                                    if (!parser.getName().equals("Package")) continue block13;
                                    this.dependencies.add(dd);
                                    continue block12;
                                }
                                case 1: {
                                    throw new Exception("Parsing failed at Package");
                                }
                            }
                        }
                    }
                    case 3: {
                        if (!parser.getName().equals("Packages")) continue block12;
                        return;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at Packages");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to parse the Deployer Report");
        }
    }

    public String getStatus() {
        return this.status;
    }

    public Set<DeployedRunningInstance> getInstances() {
        return this.instances;
    }

    public final class DeployedRunningInstance {
        private ScopedRunningInstance instance;
        private String riid;
        private String serviceClass;
        private String serviceName;
        private String serviceVersion;
        private String packageName;
        private String packageVersion;
        private boolean isAlive;
        private String message;

        public ScopedRunningInstance getInstance() {
            return this.instance;
        }

        public void setInstance(ScopedRunningInstance instance) {
            this.instance = instance;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public void setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public void setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public String getRIID() {
            return this.riid;
        }

        public void setRIId(String riid) {
            this.riid = riid;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void setAlive(boolean isAlive) {
            this.isAlive = isAlive;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.riid == null ? 0 : this.riid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeployedRunningInstance other = (DeployedRunningInstance)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.riid == null ? other.riid != null : !this.riid.equals(other.riid));
        }

        private DeployerReport getOuterType() {
            return DeployerReport.this;
        }
    }
}

