/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import java.util.HashSet;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceList;

public class ScopedResourceManagerOperator
extends Operator {
    private ResourceList resources;

    public ScopedResourceManagerOperator(ScopeState scopeState, OperatorConfig configuration, ResourceList resources, Operator.ACTION action) {
        this.configuration = configuration;
        this.resources = resources;
        this.action = action;
        this.scopeState = scopeState;
    }

    @Override
    public void exec() throws Exception {
        HashSet<ScopedResource> toadd = new HashSet<ScopedResource>();
        HashSet<ScopedResource> toremove = new HashSet<ScopedResource>();
        ScopedResource sresource = null;
        ResourceItem[] resourceItemArray = this.resources.getResource();
        int n = resourceItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceItem resource = resourceItemArray[n2];
            try {
                sresource = ScopedResourceFactory.newResource(this.scopeState.getScope(), resource.getID(), resource.getType());
                if (this.action == Operator.ACTION.ADD) {
                    this.logger.info((Object)("Adding resource " + sresource.getId() + " (" + sresource.getType() + ") to scope " + this.configuration.scope.toString()));
                    toadd.add(sresource);
                } else if (this.action == Operator.ACTION.REMOVE) {
                    this.logger.info((Object)("Removing resource " + sresource.getId() + " (" + sresource.getType() + ") from scope " + this.configuration.scope.toString()));
                    toremove.add(sresource);
                }
                this.configuration.session.addResource(sresource);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to manage the resource", (Throwable)e);
            }
            ++n2;
        }
        if (toadd.size() > 0) {
            this.configuration.scopeState.addResources(toadd);
        }
        if (toremove.size() > 0) {
            this.configuration.scopeState.removeResources(toremove);
        }
        this.configuration.session.save();
    }
}

