/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.porttypes;

import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.operators.AddResourcesOperator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.operators.RemoveResourcesOperator;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.porttypes.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.porttypes.ScopeUtils;
import org.gcube.vremanagement.resourcemanager.stubs.binder.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.RemoveResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourcesCreationFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourcesRemovalFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.common.InvalidScopeFaultType;

public class ResourceBinder
extends ResourceManagerPortType {
    public synchronized String addResources(AddResourcesParameters resourceList) throws ResourcesCreationFaultType, GCUBEFault {
        this.logger.debug((Object)("AddResources operation invoked in scope " + ServiceContext.getContext().getScope().getName()));
        GCUBEScope targetScope = ScopeUtils.validate(resourceList.getTargetScope());
        if (!ScopeUtils.exists(targetScope, this)) {
            this.logger.warn((Object)("Target scope " + targetScope.toString() + " does not exists and cannot be modified"));
            throw new InvalidScopeFaultType();
        }
        try {
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.AddResources, targetScope);
            this.getInstanceState().addSession(targetScope, report);
            new AddResourcesOperator(this.getInstanceState().getState(targetScope), new OperatorConfig(report, this.getInstanceState().getState(targetScope), targetScope), resourceList).run();
            return report.getId();
        }
        catch (GCUBEScopeManager.IllegalScopeException ise) {
            this.logger.error((Object)("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance"), (Throwable)ise);
            throw ServiceContext.getContext().getDefaultException("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance", ise).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to manage the input given resources(s) within the scope: " + e.getMessage()), (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to manage the input given resources(s) within the scope: " + e.getMessage(), e).toFault(new String[0]);
        }
    }

    public synchronized String removeResources(RemoveResourcesParameters resourceList) throws ResourcesRemovalFaultType, InvalidScopeFaultType {
        GCUBEScope targetScope = ScopeUtils.validate(resourceList.getTargetScope());
        if (!ScopeUtils.exists(targetScope, this)) {
            this.logger.warn((Object)("Target scope " + targetScope.toString() + " does not exists and cannot be modified"));
            throw new InvalidScopeFaultType();
        }
        try {
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.RemoveResources, targetScope);
            this.getInstanceState().addSession(targetScope, report);
            new RemoveResourcesOperator(this.getInstanceState().getState(targetScope), new OperatorConfig(report, this.getInstanceState().getState(targetScope), targetScope), resourceList).run();
            return report.getId();
        }
        catch (GCUBEScopeManager.IllegalScopeException ise) {
            this.logger.error((Object)("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance"), (Throwable)ise);
            throw new InvalidScopeFaultType();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to manage the input given resources(s) within the scope: " + e.getMessage()), (Throwable)e);
            throw new ResourcesRemovalFaultType();
        }
    }
}

