/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Serializer;
import org.globus.wsrf.NoSuchResourceException;

class ScopeStateList {
    Map<GCUBEScope, ScopeState> states = new HashMap<GCUBEScope, ScopeState>();
    protected GCUBELog logger = new GCUBELog(ScopeStateList.class);

    ScopeStateList() {
    }

    void initializeScope(GCUBEScope scope) throws Exception {
        this.logger.debug((Object)("initialising scope " + scope.toString()));
        try {
            this.states.put(scope, this.loadState(scope));
            this.logger.debug((Object)("scope state " + scope.toString() + " created from a previously serialized state"));
        }
        catch (Exception e) {
            this.states.put(scope, this.createState(scope));
            this.logger.debug((Object)("scope state " + scope.toString() + " created from scratch"));
        }
    }

    ScopeState loadState(GCUBEScope scope) throws NoSuchResourceException {
        ScopeState scopeState = new ScopeState();
        try {
            this.logger.info((Object)("initializing scope " + scope.getName() + " from the local file system..."));
            Serializer.load(scopeState, scope);
            this.getPublishedScopeResource(scope).loadFromLocalState(scopeState);
        }
        catch (Exception e) {
            this.logger.warn((Object)"local serialized scope is not available");
            this.logger.info((Object)"loading the instance state from the IS...");
            if (this.getPublishedScopeResource(scope).load()) {
                this.logger.info((Object)("scope " + scope.getName() + " successfully harvested from the IS"));
                scopeState.initialize(scope, scope.getName(), GHNContext.getContext().isSecurityEnabled(), new String[0]);
                this.getPublishedScopeResource(scope).to(scopeState);
            }
            throw new NoSuchResourceException();
        }
        return scopeState;
    }

    PublishedScopeResource getPublishedScopeResource(GCUBEScope scope) throws NoSuchResourceException {
        try {
            return PublishedScopeResource.getResource(scope);
        }
        catch (Exception e) {
            throw new NoSuchResourceException();
        }
    }

    Collection<ScopeState> getAllStates() {
        return Collections.unmodifiableCollection(this.states.values());
    }

    ScopeState getState(GCUBEScope scope) {
        return this.states.get(scope);
    }

    ScopeState createState(GCUBEScope scope) throws NoSuchResourceException, Exception {
        this.logger.info((Object)("creating scope state for " + scope.getName()));
        ScopeState scopeState = new ScopeState();
        scopeState.initialize(scope, scope.getName(), GHNContext.getContext().isSecurityEnabled(), new String[0]);
        this.getPublishedScopeResource(scope).loadFromLocalState(scopeState);
        this.states.put(scope, scopeState);
        return scopeState;
    }

    void removeState(ScopeState scopeState) {
        this.states.remove(scopeState.getScope());
    }
}

