/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.impl.platforms;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.resources.runninginstance.AccessPoint;
import org.gcube.common.core.resources.runninginstance.DeploymentData;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.resources.runninginstance.RunningInstanceInterfaces;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;

public class PlatformApplication {
    private DeployedPackage dpackage;
    private UndeployedPackage upackage;
    private GCUBERunningInstance instance;
    private GCUBELog logger = new GCUBELog((Object)this);

    protected PlatformApplication(String riid, GCUBEScope scope) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", riid)});
        List results = client.execute((ISQuery)query, scope);
        if (results.size() == 0) {
            throw new Exception("Unable to find a RI with id=" + riid);
        }
        this.instance = (GCUBERunningInstance)results.iterator().next();
    }

    public PlatformApplication(GCUBERunningInstance instance) throws Exception {
        this.instance = instance;
    }

    protected PlatformApplication(DeployedPackage dpackage, VirtualPlatform platform) throws Exception {
        this.dpackage = dpackage;
        this.instance = (GCUBERunningInstance)GHNContext.getImplementation(GCUBERunningInstance.class);
        GHNContext nodecontext = GHNContext.getContext();
        Package source = this.dpackage.getSourcePackage();
        this.instance.setLogger(this.logger);
        this.instance.setResourceVersion(this.instance.getLastResourceVersion());
        this.instance.setDescription(source.getDescription());
        this.instance.setGHNID(nodecontext.getGHNID());
        this.instance.setServiceClass(source.getServiceClass());
        this.instance.setServiceName(source.getServiceName());
        this.instance.setServiceID(dpackage.getSourcePackage().getServiceID());
        PlatformDescription platformDesc = new PlatformDescription();
        platformDesc.setName(platform.getName());
        platformDesc.setVersion(platform.getVersion());
        platformDesc.setMinorVersion(platform.getMinorVersion());
        this.instance.setPlatform(platformDesc);
        this.instance.setInstanceVersion(source.getVersion());
        DeploymentData data = new DeploymentData();
        data.setActivationTime(Calendar.getInstance());
        this.instance.setDeploymentData(data);
        AccessPoint access = new AccessPoint();
        RunningInstanceInterfaces ris = new RunningInstanceInterfaces();
        List eprs = ris.getEndpoint();
        for (String ep : dpackage.getEndpoints()) {
            Endpoint epr = new Endpoint();
            epr.setEntryName("");
            epr.setValue(ep);
            eprs.add(epr);
        }
        access.setRunningInstanceInterfaces(ris);
        this.instance.setAccessPoint(access);
    }

    protected PlatformApplication(UndeployedPackage upackage) throws Exception {
        this.upackage = upackage;
        Package dpackage = this.upackage.getSourcePackage();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//GHN/@UniqueID", GHNContext.getContext().getGHNID()), new AtomicCondition("//ServiceClass", dpackage.getServiceClass()), new AtomicCondition("//ServiceName", dpackage.getServiceName())});
        this.logger.trace((Object)("Looking for the package to unregister in the following scope " + dpackage.getScope()));
        List results = client.execute((ISQuery)query, dpackage.getScope());
        if (results.size() == 0) {
            throw new Exception("Unable to find a RI for " + dpackage.getServiceClass() + ", " + dpackage.getServiceName());
        }
        this.instance = (GCUBERunningInstance)results.iterator().next();
    }

    public void publish(Collection<GCUBEScope> scopes, GCUBESecurityManager manager, GCUBEServiceContext.Status ... status) throws Exception {
        this.instance.addScope(scopes.toArray(new GCUBEScope[0]));
        if (status != null && status.length > 0) {
            this.instance.getDeploymentData().setState(status[0].toString());
        }
        this.instance.setGHNID(GHNContext.getContext().getGHNID());
        ISPublisher publisher = null;
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
            for (GCUBEScope scope : scopes) {
                publisher.registerGCUBEResource((GCUBEResource)this.instance, scope, manager);
            }
            this.logger.debug((Object)("RI " + this.instance.getID() + " re-published"));
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to publish", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void unpublish(Collection<GCUBEScope> scopes, GCUBESecurityManager manager) throws Exception {
        ISPublisher publisher = null;
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
            for (GCUBEScope scope : scopes) {
                this.instance.removeScope(new GCUBEScope[]{scope});
                publisher.removeGCUBEResource(this.instance.getID(), "RunningInstance", scope, manager);
            }
            if (this.instance.getScopes().values().size() > 0) {
                for (GCUBEScope scope : this.instance.getScopes().values()) {
                    publisher.removeGCUBEResource(this.instance.getID(), this.instance.getType(), scope, manager);
                }
            }
            this.logger.debug((Object)("RI " + this.instance.getID() + " unpublished"));
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to unpublish", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

