/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.stubs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.plugins.GCUBEPluginContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.WSCall;

public abstract class BaseCall
extends WSCall {
    private static String conditionsFormat = "some $task in $result/child::*[local-name()='Task'] satisfies ($task/child::*[local-name()='name']/string() eq '%1$s'%2$s)";
    private static String propertyConditionFormat = " and (some $prop in $task/child::*[local-name()='property'] satisfies ($prop/child::*[local-name()='name']/string() eq '%1$s' and $prop/child::*[local-name()='value']/string() eq '%2$s'))";
    protected String taskName;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected List<GCUBEPluginContext.TypeMapping> mappings = new ArrayList<GCUBEPluginContext.TypeMapping>();
    private boolean isQueryPrepared = false;

    protected BaseCall(String taskName, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        this(scope, securityManager);
        this.taskName = taskName;
    }

    protected BaseCall(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        super(scope, securityManager);
    }

    protected String getServiceClass() {
        return "VREManagement";
    }

    protected String getServiceName() {
        return "Executor";
    }

    public void setTaskProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public synchronized void setQuery(WSResourceQuery query) {
        super.setQuery((ISQuery)query);
        this.isQueryPrepared = false;
    }

    public synchronized WSResourceQuery getQuery() {
        WSResourceQuery query = (WSResourceQuery)super.getQuery();
        if (this.isQueryPrepared) {
            return query;
        }
        StringBuilder propertyConditions = new StringBuilder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            propertyConditions.append(String.format(propertyConditionFormat, entry.getKey(), entry.getValue()));
        }
        query.addGenericCondition(String.format(conditionsFormat, this.taskName, propertyConditions.toString()));
        this.isQueryPrepared = true;
        this.logger.trace((Object)query.getExpression());
        return query;
    }
}

