package org.gcube.vremanagement.executor.stubs;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

/**
 * Constants and utilities for interaction with the Executor service.
 * 
 * @author Fabio Simeoni (University of Strathclyde)
 */
public class Utils {

	/** Service name. */
	public static final String SERVICE_NAME = "Executor";
	/** Service class. */
	public static final String SERVICE_CLASS = "VREManagement";
	/** Executor's namespace. */
	public static final String NS = "http://gcube-system.org/namespaces/vremanagement/executor";
	/** Relative endpoint of the Engine port-type. */
	public static final String ENGINE_PT_NAME = "gcube/vremanagement/executor/engine";
	/** Relative endpoint of the Task port-type. */
	public static final String TASK_PT_NAME = "gcube/vremanagement/executor/task";
	/** Name of the task RP of the Engine port-type. */
	public static final String ENGINE_TASKRP_NAME = "Task";
	/** Name of the name field of task descriptions. */
	public static final String ENGINE_TASKNAME_NAME = "name";
	/** Name of the property field of task descriptions. */
	public static final String ENGINE_TASKPROPERTY_NAME = "property";
	/** Name of the name field of the property field of task descriptions. */
	public static final String ENGINE_TASKPROPERTYNAME_NAME = "name";
	/** Name of the value field of the property field of task descriptions. */
	public static final String ENGINE_TASKPROPERTYVALUE_NAME = "value";
	/** Fully qualified name of the State RP of Task resources. */
	public static final QName TASK_STATE_RP = new QName(NS, "State");
	/** Fully qualified name of the Output RP of Task resources. */
	public static final QName TASK_OUTPUT_RP = new QName(NS, "Outputs");
	/** Fully qualified name of the Input RP of Task resources. */
	public static final QName TASK_INPUT_RP = new QName(NS, "Inputs");
	/** Fully qualified name of the Log RP of Task resources. */
	public static final QName TASK_LOG_RP = new QName(NS, "Log");
	/** Fully qualified name of the Error RP of Task resources. */
	public static final QName TASK_ERROR_RP = new QName(NS, "Error");
	/** Fully qualified name of the Started RP of Task resources. */
	public static final QName TASK_STARTED_RP = new QName(NS, "Started");
	/** Fully qualified name of the Type RP of Task resources. */
	public static final QName TASK_TYPE_RP = new QName(NS, "Type");

	/**
	 * Used internally to convert an external acyclic structure into an internal
	 * structure.
	 * 
	 * @param external
	 *            the external structure.
	 * @return the internal structure.
	 * @throws IllegalArgumentException
	 *             if the external structure contains cycles or shared nodes.
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, Object> intern(AnyMap external)
			throws IllegalArgumentException {
		return (Map<String, Object>) intern(external, new ArrayList<Integer>()); // trust
																					// this
	}

	// recursive overloading of intern()
	private static Object intern(Object external, List<Integer> history) {

		// System.out.println("interning "+external);
		if (external == null)
			return null;

		// cycle detection
		int h = external.hashCode();
		if (history.contains(h))
			throw new IllegalArgumentException(
					"input contains cycles or shared nodes");
		// remember for later detection
		history.add(h);

		if (external instanceof StringHolder)
			return ((StringHolder) external).getValue();

		if (external instanceof AnyMap) {
			AnyMap anyMap = (AnyMap) external;
			Map<String, Object> map = new TreeMap<String, Object>(); // maintains
																		// order
			AnyPair[] anyEntries = anyMap.getEntries();
			if (anyEntries == null)
				return null;
			else
				for (AnyPair anyEntry : anyEntries)
					map.put(anyEntry.getName(), intern(anyEntry.getValue(),
							history));
			return map;
		}

		if (external instanceof AnyArray) {
			AnyArray anyArray = (AnyArray) external;
			List<Object> list = new ArrayList<Object>();
			for (Object anyElement : anyArray.getElements())
				list.add(intern(anyElement, history));
			return list.toArray();
		}

		return external;
	}

	/**
	 * Used internally to convert an internal structure into an external
	 * structure.
	 * 
	 * @param internal
	 *            the internal structure.
	 * @return the external structure.
	 * @throws IllegalArgumentException
	 *             if the internal structure contains cycles or shared nodes.
	 */
	public static AnyMap extern(Map<String, Object> internal)
			throws IllegalArgumentException {
		return (AnyMap) extern(internal, new ArrayList<Integer>());
	}

	private static Object extern(Object internal, List<Integer> history) throws IllegalArgumentException {

		System.out.println("externing "+internal);
		
		if (internal == null)
		    return null;
		
		int h = internal.hashCode();
		
		if (history.contains(h))
		    throw new IllegalArgumentException(
		            "input contains cycles or shared nodes");
		
		if (internal instanceof String) {
		    System.out.println("wrapping "+internal);
		    return new StringHolder((String) internal);
		}
		
		
		if (internal instanceof Map<?, ?>) {
			history.add(h);
		    Map<?, ?> map = (Map<?, ?>) internal;
		    List<AnyPair> anyEntries = new ArrayList<AnyPair>();
		    if (map.entrySet() == null)
		        return null;
		    else
		        for (Entry<?, ?> entry : map.entrySet())
		            anyEntries.add(new AnyPair(entry.getKey() == null ? null
		                    : entry.getKey().toString(), extern(entry
		                    .getValue(), history)));
		    return new AnyMap(anyEntries.toArray(new AnyPair[0]));
		}
		
		if (internal instanceof Collection<?>) {
			history.add(h);
		    Collection<?> coll = (Collection<?>) internal;
		    List<Object> elements = new ArrayList<Object>();
		    for (Object el : coll)
		        elements.add(extern(el,history));
		    return new AnyArray(elements.toArray());
		}
		
		if (internal.getClass().isArray()) {
			history.add(h);
		    List<Object> elements = new ArrayList<Object>();
		    for (int i = 0; i < Array.getLength(internal); i++)
		        elements.add(extern(Array.get(internal, i), history));
		    return new AnyArray(elements.toArray());
		}
		
		return internal;
	}

//	public static void main(String[] args) {
//
//		AnyMap ext = new AnyMap(new AnyPair[] { new AnyPair("one", 1),
//				new AnyPair("two", 2) });
//
//		System.out.println("was: " + ext);
//		System.out.println("roundtrip: " + extern(intern(ext)).equals(ext));
//
//		Map<String, Object> m = new HashMap<String, Object>();
//		m.put("foo", new int[] { 1, 2, 3 });
//		System.out.println(extern(m));
//
//	}

}
