package org.gcube.vremanagement.executor.plugin;

import org.gcube.common.core.contexts.GCUBEPortTypeContext;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.vremanagement.executor.contexts.EnginePTContext;
import org.gcube.vremanagement.executor.contexts.TaskPTContext;

/**
 * Extends {@link GCUBEPluginManager} to manage service plugins.
 * @author Fabio Simeoni (University of Strathclyde)
 */
public class ExecutorPluginManager extends GCUBEPluginManager<ExecutorPluginContext> {

	/**{@inheritDoc}*/
	protected Class<ExecutorPluginContext> getMainClass() {return ExecutorPluginContext.class;}	
	
	/**{@inheritDoc}*/
	protected GCUBEPortTypeContext[] getPortTypeContexts(){return new GCUBEPortTypeContext[]{EnginePTContext.getContext(),TaskPTContext.getContext()};}
	
	/**{@inheritDoc}*/
	public ExecutorPluginContext validateMainClass(Class<?> contextClass) throws Exception {
		ExecutorPluginContext context = super.validateMainClass(contextClass);
		try{
			context.getTaskClass().newInstance();
		}catch(Exception e) {throw new Exception(context.getTaskClass().getSimpleName()+" is not reflectively instantiable");}
		return context;
	}
	
}
