/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.vremanagement.executor.contexts.EnginePTContext;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;
import org.gcube.vremanagement.executor.state.TaskResource;
import org.globus.wsrf.NoSuchResourceException;

public class TaskPersistenceDelegate
extends GCUBEWSFilePersistenceDelegate<TaskResource> {
    protected void onLoad(TaskResource resource, ObjectInputStream stream) throws Exception {
        super.onLoad((GCUBEWSResource)resource, stream);
        while (ServiceContext.getContext().getStatus() != GCUBEServiceContext.Status.READIED) {
            Thread.sleep(100L);
        }
        ExecutorPluginContext context = EnginePTContext.getContext().getEngine().getContext((String)stream.readObject());
        if (context == null) {
            throw new NoSuchResourceException();
        }
        resource.setContext(context);
        resource.setStartTime((Calendar)stream.readObject());
        resource.setInputs((Map)stream.readObject());
        resource.setOutputs((Map)stream.readObject());
        resource.setLog((String)stream.readObject());
        resource.setError((String)stream.readObject());
        resource.setState((String)stream.readObject());
        if (resource.getTerminationTime() == null) {
            GCUBEScope scope = GCUBEScope.getScope((String)((String)resource.getResourcePropertySet().getScope().get(0)));
            ServiceContext.getContext().setScope(scope);
            resource.launch(scope);
        }
    }

    protected void onStore(TaskResource resource, ObjectOutputStream stream) throws Exception {
        super.onStore((GCUBEWSResource)resource, stream);
        stream.writeObject(resource.getContext().getDescription().getName());
        stream.writeObject(resource.getStartTime());
        stream.writeObject(resource.getInputs());
        stream.writeObject(resource.getOutputs());
        stream.writeObject(resource.getLog());
        stream.writeObject(resource.getError());
        stream.writeObject(resource.getTask().getState().toString());
    }
}

