package org.gcube.vremanagement.executor.porttypes;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.contexts.TaskPTContext;
import org.gcube.vremanagement.executor.state.TaskResource;

public class TaskPT extends GCUBEPortType {

	@Override protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	/**
	 * Attempts to stop the execution of the task.
	 * @throws GCUBERetrySameFault if the task could not be stopped.
	 * * @throws GCUBEUnrecoverableFault if the task cannot be stopped.
	 **/
	public void stop() throws GCUBERetrySameFault,GCUBEUnrecoverableFault {
		String errMsg = "could not stop the task";
		try {
			TaskResource task = (TaskResource) TaskPTContext.getContext().getWSHome().find();
			task.stop();
		}
		catch (UnsupportedOperationException e) {
			logger.error(errMsg,e);
			throw new GCUBEUnrecoverableFault(e);
	    }
		catch (Exception e) {
			logger.error(errMsg,e);
			throw new GCUBERetrySameFault(e);
	    }
	}
}
