package org.gcube.vremanagement.executor.contexts;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;

/**
 * The context of the the service.
 * @author Fabio Simeoni (University of Strathclyde).
 **/
public class ServiceContext extends GCUBEServiceContext{
	
	/** Name of the JNDI configuration of the service. */
	public static final String JNDI_NAME="gcube/vremanagement/executor";
	
	/** Single context instance, created eagerly */
	private static ServiceContext singleton = new ServiceContext();
		
	/** {@inheritDoc} */
	protected String getJNDIName() {return JNDI_NAME;}
	
	/** Prevents accidental creation of more instances */
	private ServiceContext(){};

	/** Returns cached instance.
	 * @return the instance. */
	public static ServiceContext getContext() {return singleton;}
	
	/** {@inheritDoc} */
	protected void onReady() throws Exception {
		super.onReady();
		//creates engine in all RI scopes
		logger.trace("creating engine resources in all RI scopes");
		EnginePTContext engineCtxt = EnginePTContext.getContext();
		for (GCUBEScope scope : this.getInstance().getScopes().values()) {
			this.setScope(scope);
			engineCtxt.createEngine();
		}
		
//		//de-registration test
//		new Thread() {
//			public void run() {try{Thread.sleep(10000);getPluginManager().deregisterPlugin("SampleStager");}catch(Exception e){logger.error("problem",e);}};
//		}.start();
	}
	
	/**{@inheritDoc}*/
	@SuppressWarnings("unchecked")
	public GCUBEPluginManager<ExecutorPluginContext> getPluginManager() {
		return (GCUBEPluginManager<ExecutorPluginContext>) super.getPluginManager();
	}
}
