/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.state;

import java.util.Map;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.types.DescriptiveProperty;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.contexts.TaskPTContext;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;
import org.gcube.vremanagement.executor.state.TaskResource;
import org.gcube.vremanagement.executor.stubs.AnyMap;
import org.gcube.vremanagement.executor.stubs.TaskDescription;
import org.globus.wsrf.ResourceProperty;

public class EngineResource
extends GCUBEWSResource {
    static final String RP_TASKS = "Task";
    private static String[] RPNames = new String[]{"Task"};

    protected void initialise(Object ... args) throws Exception, IllegalArgumentException {
        this.logger.trace((Object)"subscribing for plugin event management");
        ServiceContext.getContext().getPluginManager().subscribe((GCUBEPluginManager.PluginConsumer)new PluginConsumer(), new GCUBEPluginManager.PluginTopic[0]);
    }

    private synchronized void setTaskRP(Map<String, ExecutorPluginContext> tasks) {
        this.logger.trace((Object)"updating taskRP property");
        ResourceProperty taskRP = this.getResourcePropertySet().get(RP_TASKS);
        taskRP.clear();
        for (ExecutorPluginContext context : tasks.values()) {
            TaskDescription description = context.getDescription();
            description.setName(context.getPlugin().getServiceName());
            description.setDescription(context.getPlugin().getDescription());
            description.setProperty(context.getProperties().values().toArray(new DescriptiveProperty[0]));
            description.setSampleInput(context.getSampleInputs().toArray(new DescriptiveProperty[0]));
            description.setSampleOutput(context.getSampleOutputs().toArray(new DescriptiveProperty[0]));
            taskRP.add((Object)description);
        }
    }

    public ExecutorPluginContext getContext(String name) throws Exception {
        ExecutorPluginContext taskContext = (ExecutorPluginContext)((Object)ServiceContext.getContext().getPluginManager().getPlugins().get(name));
        if (taskContext == null) {
            throw new GCUBERetryEquivalentException("task " + name + " is unknown");
        }
        return taskContext;
    }

    public TaskResource launch(String name, AnyMap input) throws Exception {
        return (TaskResource)TaskPTContext.getContext().getWSHome().create(new Object[]{this.getContext(name), input});
    }

    public String[] getPropertyNames() {
        return RPNames;
    }

    private class PluginConsumer
    extends GCUBEPluginManager.PluginConsumer<ExecutorPluginContext> {
        private PluginConsumer() {
        }

        public <T1 extends GCUBEPluginManager.PluginTopic, P1 extends ExecutorPluginContext> void onEvent(GCUBEEvent<T1, P1> ... events) {
            EngineResource.this.logger.trace((Object)"received a plugin management event");
            EngineResource.this.setTaskRP(ServiceContext.getContext().getPluginManager().getPlugins());
        }
    }
}

