package org.gcube.common.vremanagement.deployer.testsuite;

import java.io.IOException;
import java.util.Properties;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployerPortType;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UpdateParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.service.DeployerServiceAddressingLocator;
import org.gcube.common.vremanagement.deployer.testsuite.DeployTest;


/**
 * Class test for the <em>Update</em> operation of the Deployer service 
 * @author manuele
 *
 */
public class UpdateTest {

protected static Properties packages = new Properties();
	
public static void main(String[] args) {
	
	if (args.length < 3)
		DeployTest.printUsage();				
	try {
		packages.load(DeployTest.class.getResourceAsStream("/samples/deploy.war.properties"));
	} catch (IOException e1) {			
		e1.printStackTrace();
		Runtime.getRuntime().exit(1);
		
	}
	//invoke the deployment 
	UpdateParameters param = new UpdateParameters();
	PackageInfo[] ps = new PackageInfo[new Integer(packages.getProperty("numOfPackagesToUpdate"))];
	
	for (int i = 1 ; i < (ps.length +1); i++) {
		ps[i-1] = new PackageInfo();
		ps[i-1].setServiceName(packages.getProperty("package." + i + ".servicename")); //service ID
		ps[i-1].setServiceClass(packages.getProperty("package." + i + ".serviceclass"));
		ps[i-1].setServiceVersion(packages.getProperty("package." + i + ".serviceversion"));
		ps[i-1].setVersion(packages.getProperty("package." + i + ".version"));			
		ps[i-1].setName(packages.getProperty("package." + i + ".name")); //packageName		
	}			
	param.set_package(ps);
	//param.setTargetScope(new String[] {});		
	param.setCallbackID(""); // callback EPR
	param.setEndpointReference(new EndpointReferenceType());

	EndpointReferenceType endpoint = new EndpointReferenceType();
	try {
		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  
			public boolean isSecurityEnabled() {return false;}};
		
		endpoint.setAddress(new Address("http://"+ args[0]+":"+ args[1] +"/wsrf/services/gcube/common/vremanagement/Deployer"));		
		DeployerServiceAddressingLocator locator = new DeployerServiceAddressingLocator();			
		DeployerPortType pt = GCUBERemotePortTypeContext.getProxy(locator.getDeployerPortTypePort(endpoint), 
				GCUBEScope.getScope(packages.getProperty("callerScope")),managerSec);			
		pt.update(param);
		
	} catch (Exception e) {
		e.printStackTrace();
	} 

}

	static void printUsage() {
		System.out.println("UpdateTest <Deployer URI> <properties file>");
		System.exit(1);
	}
}
