/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.util;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resource.management.quota.manager.check.QuotaUsage;
import org.gcube.resource.management.quota.manager.util.DiscoveryConfiguration;
import org.gcube.resource.management.quota.manager.util.DiscoveryListUser;
import org.gcube.resource.management.quota.manager.util.DiscoveryService;
import org.gcube.resource.management.quota.manager.util.ListUser;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendNotification {
    private String identifier;
    private Double quotaAssigned;
    private Double quotaUsage;
    private Double percent;
    private String urlService;
    private DiscoveryConfiguration discoveryCheck;
    private static final String WRITE_MESSAGE = "2/messages/write-message";
    private static final String NAME_USERNAME_GLOBAL_ROLE = "2/users/get-usernames-by-global-role";
    private static Logger log = LoggerFactory.getLogger(QuotaUsage.class);

    public SendNotification(DiscoveryConfiguration discoveryCheck) {
        this.discoveryCheck = discoveryCheck;
        String context = ScopeProvider.instance.get();
        DiscoveryService discoveryList = new DiscoveryService(context);
        this.urlService = discoveryList.getBasePath() + WRITE_MESSAGE;
    }

    public void configure(String identifier, Double quotaAssigned, Double quotaUsage, Double percent) {
        this.identifier = identifier;
        this.quotaAssigned = quotaAssigned;
        this.quotaUsage = quotaUsage;
        this.percent = percent;
    }

    public boolean sendNotificationUser(String identifier, Double quotaAssigned, Double quotaUsage, Double percent, String type) throws JSONException {
        Boolean resultSend = false;
        if (this.discoveryCheck.getNotifierUser().booleanValue()) {
            this.configure(identifier, quotaAssigned, quotaUsage, percent);
            log.debug("Notification Quota limit used:{} identifier:{} quotaAssigned:{} quotaUsage:{} ", new Object[]{this.percent, this.identifier, this.quotaAssigned, this.quotaUsage});
            String body = null;
            String subject = null;
            if (type == "warning") {
                body = this.CleanNotification(this.discoveryCheck.getTextQuotaUserWarning());
                subject = this.discoveryCheck.getTextQuotaUserWarningSubject();
            }
            if (type == "exceed") {
                body = this.CleanNotification(this.discoveryCheck.getTextQuotaUserExceed());
                subject = this.discoveryCheck.getTextQuotaUserExceedSubject();
            }
            if (type == "reset") {
                body = this.CleanNotification(this.discoveryCheck.getTextQuotaUserReset());
                subject = this.discoveryCheck.getTextQuotaUserResetSubject();
            }
            if (type == "change") {
                body = this.CleanNotification(this.discoveryCheck.getTextQuotaUserChange());
                subject = this.discoveryCheck.getTextQuotaUserChangeSubject();
            }
            String token = SecurityTokenProvider.instance.get();
            JSONObject urlParameters = new JSONObject();
            ArrayList<String> user = new ArrayList<String>();
            user.add(identifier);
            urlParameters.put("recipients", user);
            urlParameters.put("body", (Object)body);
            urlParameters.put("subject", (Object)subject);
            try {
                resultSend = this.writeMsg(this.urlService, urlParameters, token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.debug("sendNotification user:{} url:{}, body:{}, subject:{}, send:{}", new Object[]{user, body, subject, resultSend});
        } else {
            log.debug("Not notification Quota limit used:{} identifier:{} quotaAssigned:{} quotaUsage:{} ", new Object[]{percent, identifier, quotaAssigned, quotaUsage});
        }
        return resultSend;
    }

    public boolean SendNotificationAdmin(List<String> userExceedQuota) throws Exception {
        log.debug("SendNotificationAdmin for user:{}", (Object)userExceedQuota.toString());
        Boolean resultSend = false;
        if (userExceedQuota.size() > 0) {
            if (this.discoveryCheck.getNotifierAdmin().booleanValue()) {
                String token = SecurityTokenProvider.instance.get();
                String context = ScopeProvider.instance.get();
                DiscoveryService discoveryList = new DiscoveryService(context);
                String urlServiceRole = discoveryList.getBasePath() + NAME_USERNAME_GLOBAL_ROLE;
                log.debug("SendNotificationAdminservice DiscoveryServiceListUserRole:" + this.urlService);
                String data = this.getJsonResult(urlServiceRole, token, this.discoveryCheck.getRoleNotifier());
                log.debug("data read:{}", (Object)data);
                ListUser msg = (ListUser)new Gson().fromJson(data, ListUser.class);
                log.debug("SendNotificationAdmin msg:{}" + msg.toString());
                List sendersList = msg.getResult();
                log.debug("SendNotificationAdmin sendersList:{}" + sendersList.toString());
                this.configure(this.identifier, this.quotaAssigned, this.quotaUsage, this.percent);
                String text = this.CleanNotification(this.discoveryCheck.getTextQuotaAdminExceed());
                String listUser = "";
                for (String s : userExceedQuota) {
                    if (s == null) continue;
                    listUser = listUser + "\n" + s;
                }
                text = text.replace("{listuser}", listUser);
                discoveryList = new DiscoveryService(context);
                String urlService = discoveryList.getBasePath() + WRITE_MESSAGE;
                log.debug("urlService:{}, text msg:{}", (Object)urlService, (Object)text);
                JSONObject urlParameters = new JSONObject();
                ArrayList<String> user = new ArrayList<String>();
                for (String cc : sendersList) {
                    user.add(cc);
                }
                urlParameters.put("recipients", user);
                urlParameters.put("body", (Object)text);
                urlParameters.put("subject", (Object)this.discoveryCheck.getTextQuotaAdminExceedSubject());
                try {
                    resultSend = this.writeMsg(urlService, urlParameters, token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                log.debug("send notification quota exceed:{} send:{}", (Object)userExceedQuota.toString(), (Object)resultSend);
            } else {
                log.debug("not send notification quota exceed :{}", (Object)userExceedQuota.toString());
            }
        }
        return resultSend;
    }

    private String CleanNotification(String notification) {
        String percentLabel;
        String quotaUsageLabel;
        String quotaAssignedLabel;
        String fullname = DiscoveryListUser.getMapUser((String)this.identifier);
        log.debug("Clean Notification from username:{} to fullname:{}", (Object)this.identifier, (Object)fullname);
        if (notification.contains("{identifier}")) {
            notification = notification.replace("{identifier}", fullname);
        }
        if (this.quotaAssigned >= 1024.0) {
            quotaAssignedLabel = String.valueOf((double)Math.round(this.quotaAssigned / 1024.0 * 100.0) / 100.0) + "GB";
            quotaUsageLabel = String.valueOf((double)Math.round(this.quotaUsage / 1024.0 * 100.0) / 100.0) + "GB";
            percentLabel = this.percent.toString();
        } else {
            quotaAssignedLabel = String.valueOf(this.quotaAssigned) + "MB";
            quotaUsageLabel = String.valueOf(this.quotaUsage) + "MB";
            percentLabel = this.percent.toString();
        }
        if (this.quotaAssigned == -1.0) {
            quotaAssignedLabel = "\u221e";
            percentLabel = "0";
        }
        if (notification.contains("{quotaAssigned}")) {
            notification = notification.replace("{quotaAssigned}", quotaAssignedLabel);
        }
        if (notification.contains("{quotaUsage}")) {
            notification = notification.replace("{quotaUsage}", quotaUsageLabel);
        }
        if (notification.contains("{percent}")) {
            notification = notification.replace("{percent}", percentLabel);
        }
        return notification;
    }

    public Boolean writeMsg(String path, JSONObject urlParameters, String token) throws Exception {
        Boolean result = false;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = clientBuilder.build();
        HttpPost request = new HttpPost(path);
        request.addHeader("gcube-token", token);
        request.addHeader("Content-type", ContentType.APPLICATION_JSON.toString());
        StringEntity params = new StringEntity(urlParameters.toString(), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)params);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        log.debug("writeMsg path:{} urlParameters:{} request:{}", new Object[]{path, urlParameters, request.toString()});
        int status = response.getStatusLine().getStatusCode();
        if (status == 500 || status == 502) {
            result = false;
        } else if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            Header[] locations = response.getHeaders("Location");
            Header lastLocation = locations[locations.length - 1];
            String realLocation = lastLocation.getValue();
            log.debug("New location is " + realLocation);
            request = new HttpPost(realLocation);
            request.addHeader("gcube-token", token);
            request.addHeader("Content-type", ContentType.APPLICATION_JSON.toString());
            params = new StringEntity(urlParameters.toString(), ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)params);
            response = httpClient.execute((HttpUriRequest)request);
            log.info(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
            result = true;
        } else {
            log.debug(" " + response.getStatusLine().getStatusCode() + " and response message is " + response.getStatusLine().getReasonPhrase());
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJsonResult(String url, String token, String role) {
        url = url + "?role-name=" + role + "&gcube-token=" + token;
        HttpURLConnection c = null;
        try {
            URL u = new URL(url);
            c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("GET");
            c.setRequestProperty("Content-length", "0");
            c.setUseCaches(false);
            c.setAllowUserInteraction(false);
            c.setInstanceFollowRedirects(true);
            c.connect();
            int status = c.getResponseCode();
            switch (status) {
                case 200: 
                case 201: {
                    BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        String line;
                        if ((line = br.readLine()) == null) {
                            br.close();
                            String string = sb.toString();
                            return string;
                        }
                        sb.append(line + "\n");
                    }
                }
            }
            return null;
        }
        catch (MalformedURLException ex) {
            log.error("MalformedURLException:{}", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            log.error("IOException:{}", (Throwable)ex);
            return null;
        }
        finally {
            if (c != null) {
                try {
                    c.disconnect();
                }
                catch (Exception ex) {
                    log.error("Exception:{}", (Throwable)ex);
                }
            }
        }
    }
}

