/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.util;

import java.security.Key;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiscoveryConfiguration {
    private String databasePath = null;
    private String usernameDb = null;
    private String pwdnameDb = null;
    private String dbname = null;
    private Boolean notifierUser = false;
    private Boolean notifierAdmin = false;
    private Integer refreshTimeQuota = 0;
    private String textQuotaUserWarning = "Hi {identifier}, your storage space is almost full, Your quota occupation is {percent} %, you are using {quotaUsage} out of {quotaAssigned} available.Please be adviced.";
    private String textQuotaUserWarningSubject = "WARNING Your storage space is about to exceed quota capacity";
    private String textQuotaUserExceedSubject = "ATTENTION  Your storage space exceeds the assigned quota capacity";
    private String textQuotaUserExceed = "Hi {identifier}, your storage space is full, Your quota occupation is {percent}% , you are using {quotaUsage} out of {quotaAssigned} available. Please free up some space.";
    private String textQuotaUserChangeSubject = "INFO your quota has changed";
    private String textQuotaUserChange = "Hi {identifier},your quota has changed to {quotaAssigned}. Your are currently occupying {percent}% of the available space.";
    private String textQuotaAdminExceedSubject = "INFO  List User quota Exceed";
    private String textQuotaAdminExceed = "Dear, the following users have exceeded their quota: {listuser}";
    private String textQuotaUserReset = "Hi {identifier}, Your quota occupation decreased and is now {percent}%, you are using {quotaUsage}, out of  {quotaAssigned} available. Good job!";
    private String textQuotaUserResetSubject = "INFO Your storage space is now sufficiently below the quota capacity";
    private String roleNotifier = "Administrator";
    private static Logger logger = LoggerFactory.getLogger(DiscoveryConfiguration.class);
    private static final String RUNTIME_RESOURCE_NAME = "Persistence";
    private static final String CATEGORY = "Quota";
    private static final String ACCESS_POINT_NAME = "postgresql Server";
    private static final String DB_NAME = "dbname";
    private static final String NOTIFIER_USER = "notifierUser";
    private static final String NOTIFIER_ADMINISTRATOR = "notifierAdministrator";
    private static final String REFRESH_TIME_QUOTA = "refreshTimeQuota";
    private static final String TEXT_QUOTA_USER_WARNING_SUBJECT = "textQuotaUserWarningSubject";
    private static final String TEXT_QUOTA_USER_WARNING = "textQuotaUserWarning";
    private static final String TEXT_QUOTA_USER_EXCEED_SUBJECT = "textQuotaUserExceedSubject";
    private static final String TEXT_QUOTA_USER_EXCEED = "textQuotaUserExceed";
    private static final String TEXT_QUOTA_USER_CHANGE_SUBJECT = "textQuotaUserChangeSubject";
    private static final String TEXT_QUOTA_USER_CHANGE = "textQuotaUserChange";
    private static final String TEXT_QUOTA_ADMIN_EXCEED_SUBJECT = "textQuotaAdminExceedSubject";
    private static final String TEXT_QUOTA_ADMIN_EXCEED = "textQuotaAdminExceed";
    private static final String TEXT_QUOTA_USER_RESET_SUBJECT = "textQuotaUserResetSubject";
    private static final String TEXT_QUOTA_USER_RESET_EXCEED = "textQuotaUserReset";
    private static final String ROLE_NOTIFIER = "roleNotifier";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryConfiguration(String context) {
        if (context == null || context.isEmpty()) {
            throw new IllegalArgumentException("A valid context is needed to discover the service");
        }
        logger.debug("find a resources from service end point in context:{}", (Object)context);
        String oldContext = ScopeProvider.instance.get();
        logger.debug("find a resources from service end point oldContext:{}", (Object)oldContext);
        ScopeProvider.instance.set(context);
        try {
            ServiceEndpoint resources = this.getServiceEndpoint(context);
            logger.debug("find a resources from service end point");
            this.setValues(resources);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
        }
        finally {
            if (oldContext != null && !oldContext.equals(context)) {
                ScopeProvider.instance.set(oldContext);
            }
        }
        logger.info("Found base path " + this.databasePath + " for the service");
    }

    protected ServiceEndpoint getServiceEndpoint(String context) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'Persistence'");
        query.addCondition("$resource/Profile/Category/text() eq 'Quota'");
        query.setResult("$resource");
        logger.debug("DiscoveryConfiguration query:{}", (Object)query.toString());
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        return (ServiceEndpoint)serviceEndpoints.get(0);
    }

    protected void setValues(ServiceEndpoint serviceEndpoint) throws Exception {
        Group accessPoints = serviceEndpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            logger.debug("accessPoint:{}", (Object)accessPoint.name());
            if (accessPoint.name().compareTo("postgresql Server") != 0) continue;
            this.databasePath = accessPoint.address();
            this.usernameDb = accessPoint.username();
            this.pwdnameDb = DiscoveryConfiguration.decrypt((String)accessPoint.password(), (Key[])new Key[0]);
            Map propertyMap = accessPoint.propertyMap();
            for (String key : propertyMap.keySet()) {
                ServiceEndpoint.Property property = (ServiceEndpoint.Property)propertyMap.get(key);
                String value = property.value();
                if (property.isEncrypted()) {
                    value = DiscoveryConfiguration.decrypt((String)value, (Key[])new Key[0]);
                }
                switch (key) {
                    case "dbname": {
                        this.dbname = value;
                        break;
                    }
                    case "notifierUser": {
                        this.notifierUser = Boolean.valueOf(value);
                        break;
                    }
                    case "notifierAdministrator": {
                        this.notifierAdmin = Boolean.valueOf(value);
                        break;
                    }
                    case "refreshTimeQuota": {
                        this.refreshTimeQuota = Integer.valueOf(value);
                        break;
                    }
                    case "textQuotaUserWarningSubject": {
                        this.textQuotaUserWarningSubject = value;
                        break;
                    }
                    case "textQuotaUserWarning": {
                        this.textQuotaUserWarning = value;
                        break;
                    }
                    case "textQuotaUserExceedSubject": {
                        this.textQuotaUserExceedSubject = value;
                        break;
                    }
                    case "textQuotaUserExceed": {
                        this.textQuotaUserExceed = value;
                        break;
                    }
                    case "textQuotaUserChangeSubject": {
                        this.textQuotaUserChangeSubject = value;
                        break;
                    }
                    case "textQuotaUserChange": {
                        this.textQuotaUserChange = value;
                        break;
                    }
                    case "textQuotaAdminExceedSubject": {
                        this.textQuotaAdminExceedSubject = value;
                        break;
                    }
                    case "textQuotaAdminExceed": {
                        this.textQuotaAdminExceed = value;
                        break;
                    }
                    case "textQuotaUserResetSubject": {
                        this.textQuotaUserResetSubject = value;
                        break;
                    }
                    case "textQuotaUserReset": {
                        this.textQuotaUserReset = value;
                        break;
                    }
                    case "roleNotifier": {
                        this.roleNotifier = value;
                    }
                }
            }
        }
    }

    private static String decrypt(String encrypted, Key ... key) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(encrypted, new Key[0]);
    }

    public String toString() {
        return "DiscoveryConfiguration [databasePath=" + this.databasePath + ", usernameDb=" + this.usernameDb + ", pwdnameDb=" + this.pwdnameDb + ", dbname=" + this.dbname + ", notifierUser=" + this.notifierUser + ", notifierAdmin=" + this.notifierAdmin + ", refreshTimeQuota=" + this.refreshTimeQuota + ", textQuotaUserWarning=" + this.textQuotaUserWarning + ", textQuotaUserWarningSubject=" + this.textQuotaUserWarningSubject + ", textQuotaUserExceedSubject=" + this.textQuotaUserExceedSubject + ", textQuotaUserExceed=" + this.textQuotaUserExceed + ", textQuotaUserChangeSubject=" + this.textQuotaUserChangeSubject + ", textQuotaUserChange=" + this.textQuotaUserChange + ", textQuotaAdminExceedSubject=" + this.textQuotaAdminExceedSubject + ", textQuotaAdminExceed=" + this.textQuotaAdminExceed + ", textQuotaUserReset=" + this.textQuotaUserReset + ", textQuotaUserResetSubject=" + this.textQuotaUserResetSubject + ", roleNotifier=" + this.roleNotifier + "]";
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public String getUsernameDb() {
        return this.usernameDb;
    }

    public String getPwdnameDb() {
        return this.pwdnameDb;
    }

    public String getDbname() {
        return this.dbname;
    }

    public Boolean getNotifierUser() {
        return this.notifierUser;
    }

    public Boolean getNotifierAdmin() {
        return this.notifierAdmin;
    }

    public Integer getRefreshTimeQuota() {
        return this.refreshTimeQuota;
    }

    public String getTextQuotaUserWarningSubject() {
        return this.textQuotaUserWarningSubject;
    }

    public String getTextQuotaUserWarning() {
        return this.textQuotaUserWarning;
    }

    public String getTextQuotaUserExceedSubject() {
        return this.textQuotaUserExceedSubject;
    }

    public String getTextQuotaUserExceed() {
        return this.textQuotaUserExceed;
    }

    public String getTextQuotaAdminExceedSubject() {
        return this.textQuotaAdminExceedSubject;
    }

    public String getTextQuotaAdminExceed() {
        return this.textQuotaAdminExceed;
    }

    public String getTextQuotaUserReset() {
        return this.textQuotaUserReset;
    }

    public String getTextQuotaUserResetSubject() {
        return this.textQuotaUserResetSubject;
    }

    public String getRoleNotifier() {
        return this.roleNotifier;
    }

    public String getTextQuotaUserChangeSubject() {
        return this.textQuotaUserChangeSubject;
    }

    public String getTextQuotaUserChange() {
        return this.textQuotaUserChange;
    }
}

