/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.check;

import com.couchbase.client.deps.io.netty.handler.timeout.TimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.resource.management.quota.library.quotalist.QuotaType;
import org.gcube.resource.management.quota.manager.check.QuotaCalculateUtil;
import org.gcube.resource.management.quota.manager.check.QuotaUsage;
import org.gcube.resource.management.quota.manager.defaults.InformationSystemQuery;
import org.gcube.resource.management.quota.manager.persistence.QuotaDBPersistence;
import org.gcube.resource.management.quota.manager.util.DiscoveryListUser;
import org.gcube.resource.management.quota.manager.util.QuotaUsageServiceValue;
import org.gcube.resource.management.quota.manager.util.QuotaUsageStorageValue;
import org.gcube.resource.management.quota.manager.util.ReadFileProperties;
import org.gcuberesource.management.quota.manager.service.exception.NotFoundQuotaExecption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCheck {
    private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);
    private QuotaUsage queryQuotaUsage;
    private QuotaDBPersistence quotaDbPersistence;
    private AccountingPersistenceQuery apq;
    private String context = null;

    public QuotaCheck(String context, QuotaUsage queryQuotaUsage, QuotaDBPersistence quotaDbPersistence, AccountingPersistenceQuery apq) throws NotFoundQuotaExecption {
        this.context = context;
        this.queryQuotaUsage = queryQuotaUsage;
        this.quotaDbPersistence = quotaDbPersistence;
        this.apq = apq;
    }

    public void getQuotaCheck() throws Exception {
        log.info("QuotaCheck - init quota check task");
        QuotaCalculateUtil quotaUtility = new QuotaCalculateUtil(this.context, this.quotaDbPersistence);
        InformationSystemQuery informationSystemQuery = new InformationSystemQuery();
        log.debug("QuotaCheck - context:{}, setQuoteDefault:{}", (Object)this.context, (Object)informationSystemQuery.getListQuotaDefault());
        quotaUtility.setQuoteDefault(informationSystemQuery.getListQuotaDefault());
        if (quotaUtility.getQuoteDefault() == null) {
            log.debug("QuotaCheck - No quota default found on IS");
            ReadFileProperties fileQuota = new ReadFileProperties("/tmp/quota.xml");
            quotaUtility.setQuoteDefault(fileQuota.getListQuotaDefault());
        }
        DiscoveryListUser discoveryListUser = new DiscoveryListUser(this.context);
        log.debug("QuotaCheck - for context:{} , list user:{}", (Object)this.context, (Object)discoveryListUser.getListUser());
        quotaUtility.verifyListUser(discoveryListUser.getListUser());
        log.debug("QuotaCheck - quotaUtility.getUsageToBeVerified():{}", (Object)quotaUtility.getUsageToBeVerified());
        Boolean error = true;
        List quoteChecked = new ArrayList();
        try {
            quoteChecked = this.apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
            error = false;
        }
        catch (TimeoutException te) {
            log.error("error timeout on call accounting", (Throwable)te);
            quoteChecked = this.apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
        }
        catch (Exception e) {
            log.error("error on call accounting", (Throwable)e);
            quoteChecked = this.apq.getUsageValueQuotaTotal(quotaUtility.getUsageToBeVerified());
        }
        log.error("error:{}", (Object)error);
        if (!error.booleanValue()) {
            log.debug("return quota usage:{}", quoteChecked);
            for (UsageValue usageIndex : quotaUtility.getUsageToBeVerified()) {
                if (usageIndex.getClz() == QuotaType.STORAGE.getQuotaTypeClass()) {
                    log.debug("----Elaborate a identifier:{}, temporalConstraint:{} , insert a quota storage", (Object)usageIndex.getIdentifier(), (Object)usageIndex.getTemporalConstraint());
                    QuotaUsageStorageValue usageStorVal = (QuotaUsageStorageValue)usageIndex;
                    this.queryQuotaUsage.insertStorageQuota(usageStorVal);
                }
                if (usageIndex.getClz() != QuotaType.SERVICE.getQuotaTypeClass()) continue;
                log.debug("----Elaborate a identifier:{}, temporalConstraint:{} , insert a quota service", (Object)usageIndex.getIdentifier(), (Object)usageIndex.getTemporalConstraint());
                QuotaUsageServiceValue usageSerVal = (QuotaUsageServiceValue)usageIndex;
                this.queryQuotaUsage.insertServiceQuota(usageSerVal);
            }
            this.queryQuotaUsage.SendNotificationAdmin();
        }
    }
}

