/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.check;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.resource.management.quota.library.quotalist.Quota;
import org.gcube.resource.management.quota.library.quotalist.QuotaType;
import org.gcube.resource.management.quota.library.quotalist.ServiceQuota;
import org.gcube.resource.management.quota.library.quotalist.StorageQuota;
import org.gcube.resource.management.quota.library.quotalist.TimeInterval;
import org.gcube.resource.management.quota.library.quotedefault.QuotaDefault;
import org.gcube.resource.management.quota.library.quotedefault.ServiceQuotaDefault;
import org.gcube.resource.management.quota.library.quotedefault.StorageQuotaDefault;
import org.gcube.resource.management.quota.manager.persistence.QuotaDBPersistence;
import org.gcube.resource.management.quota.manager.util.QuotaUsageStorageValue;
import org.gcuberesource.management.quota.manager.service.exception.NotFoundQuotaPackageExecption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaCalculateUtil {
    private static Logger log = LoggerFactory.getLogger(QuotaCalculateUtil.class);
    private QuotaDBPersistence quotaDbPersistence;
    private List<QuotaDefault> quoteDefault = null;
    private String context;
    private List<UsageValue> usageToBeVerified = new ArrayList();

    public void setQuoteDefault(List<QuotaDefault> quoteDefault) {
        this.quoteDefault = quoteDefault;
    }

    public List<QuotaDefault> getQuoteDefault() {
        return this.quoteDefault;
    }

    public List<UsageValue> getUsageToBeVerified() {
        return this.usageToBeVerified;
    }

    public QuotaCalculateUtil(String context, QuotaDBPersistence quotaDbPersistence) {
        this.context = context;
        this.quotaDbPersistence = quotaDbPersistence;
    }

    public void verifyListUser(List<String> listUser) {
        for (String identifier : listUser) {
            log.trace("verify for user:{} in context:{},if have a no default quota", (Object)identifier, (Object)this.context);
            for (QuotaDefault quotaDefault : this.quoteDefault) {
                Quota quotaSpecified = null;
                quotaSpecified = this.quotaDbPersistence.getQuotaSpecified(identifier, this.context, quotaDefault.getQuotaType(), quotaDefault.getTimeInterval(), quotaDefault.getQuotaValue());
                log.debug("quota Specified:{} quotaDefault:{}", (Object)quotaSpecified, (Object)quotaDefault);
                if (quotaSpecified == null) {
                    if (quotaDefault.getQuotaType() == QuotaType.SERVICE) {
                        log.debug("identifier:{} used quota SERVICE", (Object)identifier);
                        ServiceQuotaDefault quotaDefaultService = (ServiceQuotaDefault)quotaDefault;
                        quotaSpecified = new ServiceQuota(this.context, identifier, quotaDefaultService.getCallerType(), quotaDefaultService.getServiceId(), quotaDefaultService.getTimeInterval(), quotaDefaultService.getQuotaValue(), quotaDefaultService.getAccessType());
                    }
                    if (quotaDefault.getQuotaType() == QuotaType.STORAGE) {
                        log.debug("identifier:{} used quota STORAGE", (Object)identifier);
                        StorageQuotaDefault quotaDefaultStorage = (StorageQuotaDefault)quotaDefault;
                        quotaSpecified = new StorageQuota(this.context, identifier, quotaDefaultStorage.getCallerType(), quotaDefaultStorage.getTimeInterval(), quotaDefaultStorage.getQuotaValue());
                    }
                }
                try {
                    log.debug("add quota into list for accounting usage value" + quotaSpecified.toString());
                    this.AddList(quotaSpecified);
                }
                catch (NotFoundQuotaPackageExecption e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void AddList(Quota quota) throws NotFoundQuotaPackageExecption {
        TimeInterval interval = quota.getTimeInterval();
        QuotaType type = quota.getQuotaType();
        Class clz = type.getQuotaTypeClass();
        log.debug("time interval get Value:{}", (Object)interval.getValue());
        TemporalConstraint temporalConstraint = null;
        if (interval.getValue() != 0) {
            Calendar endTime = Calendar.getInstance();
            Calendar startTime = Calendar.getInstance();
            startTime.add(5, -interval.getValue());
            temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), interval.getAggregationMode());
        }
        if (!quota.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            QuotaUsageStorageValue totalFilterQuota = new QuotaUsageStorageValue(quota.getContext(), quota.getIdentifier(), clz, temporalConstraint);
            totalFilterQuota.setdQuota(quota.getQuotaValue());
            log.debug("totalfilter:{}", (Object)totalFilterQuota.toString());
            this.usageToBeVerified.add(totalFilterQuota);
        }
    }

    public void insertPolicyBlock(Quota quotaBlocked) {
        log.info("Quota Execed insert a policy :{}", (Object)quotaBlocked.toString());
        String token = null;
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(quotaBlocked.getContext(), new ArrayList()), quotaBlocked.getContext());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        SecurityTokenProvider.instance.set(token);
        ArrayList policies = new ArrayList();
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.SERVICE)) {
            // empty if block
        }
        if (quotaBlocked.getQuotaType().equals((Object)QuotaType.STORAGE)) {
            // empty if block
        }
        try {
            log.debug("insert policy for quota:" + ((Object)policies).toString());
            Constants.authorizationService().addPolicies(policies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

