/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.rest.administration;

import com.webcohesion.enunciate.metadata.rs.ResourceGroup;
import com.webcohesion.enunciate.metadata.rs.ResourceLabel;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.swagger.OperationId;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.xml.ws.WebServiceException;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.resourcemanagement.annotation.PURGE;
import org.gcube.resourcemanagement.rest.administration.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="admin/configurations")
@ResourceGroup(value="Administration APIs")
@ResourceLabel(value="Configuration APIs")
public class Configuration
extends Admin {
    private static Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String CONFIGURATIONS_PATH = "configurations";
    public static final String CURRENT_CONTEXT_PATH_PARAMETER = "CURRENT_CONTEXT";
    public static final String CONTEXT_FULLNAME_PARAMETER = "CONTEXT_FULLNAME_PARAMETER";

    protected String checkContext(String context) throws WebServiceException {
        if (context == null || context.compareTo("") == 0) {
            throw new BadRequestException("Please provide a valid context as path parameter");
        }
        String c = SecretManagerProvider.get().getContext();
        if (context.compareTo(CURRENT_CONTEXT_PATH_PARAMETER) == 0) {
            return c;
        }
        if (context.compareTo(c) != 0) {
            throw new BadRequestException("Context provided as path parameter (i.e. " + context + ") does not match with token request context (i.e. " + c + ")");
        }
        return c;
    }

    private String createOrUpdate() throws WebServiceException {
        return null;
    }

    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Resource Manager configuration successfully created."), @ResponseCode(code=401, condition="Only Manager can create the configuration."), @ResponseCode(code=500, condition="Error while persisting the configuration.")})
    public Response create(String json) throws WebServiceException {
        try {
            String ret = this.createOrUpdate();
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.CREATED);
            if (ret != null) {
                responseBuilder.entity((Object)ret).type("application/json;charset=UTF-8");
            }
            return responseBuilder.build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{CONTEXT_FULLNAME_PARAMETER}")
    @Produces(value={"application/json;charset=UTF-8"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Resource Manager configuration successfully read."), @ResponseCode(code=401, condition="Only User with role Manager above can read the configuration."), @ResponseCode(code=500, condition="Error while reading the configuration.")})
    public Response read(@PathParam(value="CONTEXT_FULLNAME_PARAMETER") String context) throws WebServiceException {
        try {
            this.checkContext(context);
            return this.read();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response read() throws WebServiceException {
        try {
            String configuration = "{}";
            logger.debug("Configuration in context {} is {}", (Object)"", (Object)configuration);
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
            if (configuration != null) {
                responseBuilder.entity((Object)configuration).type("application/json;charset=UTF-8");
            }
            return responseBuilder.build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{CONTEXT_FULLNAME_PARAMETER}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Resource Manager configuration successfully created/updated."), @ResponseCode(code=401, condition="Only User with role Manager above can create/update the configuration."), @ResponseCode(code=500, condition="Error while creating/updating the configuration.")})
    @OperationId(value="Create or Update")
    public String createOrUpdate(@PathParam(value="CONTEXT_FULLNAME_PARAMETER") String context, String json) throws WebServiceException {
        try {
            return "{}";
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response update(String json) throws WebServiceException {
        try {
            String configuration = "{}";
            logger.debug("Configuration in context {} has been updated to {}", (Object)"", (Object)configuration);
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
            if (configuration != null) {
                responseBuilder.entity((Object)configuration).type("application/json;charset=UTF-8");
            }
            return responseBuilder.build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @PATCH
    @Path(value="/{CONTEXT_FULLNAME_PARAMETER}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Resource Manager configuration successfully patched."), @ResponseCode(code=401, condition="Only User with role Manager above can patch the configuration."), @ResponseCode(code=500, condition="Error while patching the configuration.")})
    public Response patch(@PathParam(value="CONTEXT_FULLNAME_PARAMETER") String context, String json) throws WebServiceException {
        try {
            this.checkContext(context);
            return this.patch(json);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response patch(String json) throws WebServiceException {
        try {
            String ret = "{}";
            logger.debug("Configuration in context {} has been patched to {}", (Object)"", (Object)ret);
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
            if (ret != null) {
                responseBuilder.entity((Object)ret).type("application/json;charset=UTF-8");
            }
            return responseBuilder.build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{CONTEXT_FULLNAME_PARAMETER}")
    @StatusCodes(value={@ResponseCode(code=200, condition="Resource Manager configuration successfully deleted."), @ResponseCode(code=401, condition="Only User with role Manager above can delete the configuration."), @ResponseCode(code=500, condition="Error while deleting the configuration.")})
    public Response delete(@PathParam(value="CONTEXT_FULLNAME_PARAMETER") String context, @QueryParam(value="purge") @DefaultValue(value="false") Boolean purge) throws WebServiceException {
        try {
            this.checkContext(context);
            if (purge.booleanValue()) {
                return this.purge();
            }
            return this.delete();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response delete() throws WebServiceException {
        try {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @PURGE
    @Path(value="/{CONTEXT_FULLNAME_PARAMETER}")
    @StatusCodes(value={@ResponseCode(code=200, condition="Resource Manager configuration purged deleted."), @ResponseCode(code=401, condition="Only User with role Manager above can purge the configuration."), @ResponseCode(code=500, condition="Error while purging the configuration.")})
    public Response purge(@PathParam(value="CONTEXT_FULLNAME_PARAMETER") String context) throws WebServiceException {
        try {
            this.checkContext(context);
            return this.purge();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public Response purge() throws WebServiceException {
        try {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

