/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.manager.webapp.rs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.gxrest.response.outbound.GXOutboundSuccessResponse;
import org.gcube.informationsystem.model.impl.entities.ContextImpl;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.utils.ISMapper;
import org.gcube.resourcemanagement.manager.io.rs.RMContextDoesNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="gxrest")
public class RMTestForGXRest {
    private static Logger logger = LoggerFactory.getLogger(RMTestForGXRest.class);

    @DELETE
    @Path(value="{ContextUUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response delete(@PathParam(value="ContextUUID") String uuid) {
        CalledMethodProvider.instance.set(String.format("DELETE /%s/%s", "/resource-manager", "gxrest"));
        this.methodOne();
        return null;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(@QueryParam(value="rrURL") String rrURL, String context) throws URISyntaxException {
        CalledMethodProvider.instance.set(String.format("POST /%s/%s", "/resource-manager", "gxrest"));
        logger.info("Requested to create resource with context {}", (Object)context);
        Context newContext = null;
        try {
            newContext = (Context)ISMapper.unmarshal(Context.class, (String)context);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            GXOutboundErrorResponse.throwExceptionWithTrace((Exception)((Object)e), (int)5);
        }
        catch (JsonMappingException e) {
            GXOutboundErrorResponse.throwExceptionWithTrace((Exception)((Object)e), (int)5);
        }
        catch (IOException e) {
            GXOutboundErrorResponse.throwExceptionWithTrace((Exception)e, (int)5);
        }
        return GXOutboundSuccessResponse.newCREATEResponse((URI)new URI(newContext.getHeader().getUUID().toString())).withContent("Context successfully created.").ofType("text/plain").build();
    }

    @PUT
    @Path(value="{ContextUUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response update(@PathParam(value="ContextUUID") String id, @QueryParam(value="rrURL") String rrURL) throws URISyntaxException, JsonProcessingException {
        CalledMethodProvider.instance.set(String.format("GET /%s/%s", "/resource-manager", "gxrest"));
        logger.info("Requested to update resource with id {}", (Object)id);
        logger.info("Force URL: " + rrURL);
        ContextImpl newContext = new ContextImpl("gxTest");
        newContext.getHeader().setUUID(UUID.fromString("6f86dc81-2f59-486b-8aa9-3ab5486313c4"));
        return GXOutboundSuccessResponse.newCREATEResponse((URI)new URI(newContext.getHeader().getUUID().toString())).withContent(ISMapper.marshal((ISManageable)newContext)).ofType("application/json").build();
    }

    private void methodOne() {
        this.methodTwo();
    }

    private void methodTwo() {
        logger.error("method 2 failed");
        GXOutboundErrorResponse.throwExceptionWithTrace((Exception)new RMContextDoesNotExistException("Error in methodTwo"), (int)3, (Response.Status)Response.Status.BAD_REQUEST);
    }

    private void methodThree() {
        logger.error("method 3 failed");
        GXOutboundErrorResponse.throwException((Exception)new RMContextDoesNotExistException("Error in methodThree"));
    }
}

