/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.context;

import java.util.UUID;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;

public class TargetContext {
    protected ResourceRegistryClient client;
    protected ContextCache contextCache;
    protected String contextFullPath;
    protected UUID uuid;
    protected Context context;
    protected Secret secret;

    protected void init() {
        this.client = ResourceRegistryClientFactory.create();
        this.contextCache = this.client.getContextCache();
    }

    public TargetContext() {
    }

    public TargetContext(Context context) throws ResourceRegistryException {
        this(context.getID());
    }

    public TargetContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        this.init();
        this.context = this.contextCache.getContextByUUID(uuid);
        this.uuid = uuid;
        this.contextFullPath = this.contextCache.getContextFullNameByUUID(uuid);
    }

    public TargetContext(String contextFullPath) throws ContextNotFoundException, ResourceRegistryException {
        this.init();
        this.context = this.contextCache.getContextByFullName(contextFullPath);
        this.contextFullPath = contextFullPath;
        this.uuid = this.context.getID();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getContextFullPath() {
        return this.contextFullPath;
    }

    public void setContextFullPath(String contextFullPath) {
        this.contextFullPath = contextFullPath;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }
}

